/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.sizing.algorithms;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.config.ModConfig;
import dev.cudzer.cobblemonsizevariation.config.Size;
import dev.cudzer.cobblemonsizevariation.sizing.SizeDefinition;
import dev.cudzer.cobblemonsizevariation.sizing.algorithms.ISizer;
import dev.cudzer.cobblemonsizevariation.utils.FileUtils;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.List;
import java.util.Random;

public class GenIXSizer
implements ISizer {
    private static final Random RNG = new Random();
    private final SizeDefinition sizeDefinition;
    private final float minSizeModifier;
    private final float maxSizeModifier;

    public GenIXSizer(SizeDefinition definition) {
        this.sizeDefinition = definition;
        this.minSizeModifier = Float.parseFloat(this.sizeDefinition.getMinSizeModifier());
        this.maxSizeModifier = Float.parseFloat(this.sizeDefinition.getMaxSizeModifier());
    }

    @Override
    public float getSize() {
        float result = 0.0f;
        if (ModConfig.biasSizeTowardAverage) {
            for (int i = 0; i < 3; ++i) {
                int value = RNG.nextInt(0, 255);
                result += (this.minSizeModifier + (float)value / 255.0f * (this.maxSizeModifier - this.minSizeModifier)) / 3.0f;
            }
        } else {
            int value = RNG.nextInt(0, 255);
            result = this.minSizeModifier + (float)value / 255.0f * (this.maxSizeModifier - this.minSizeModifier);
        }
        return result;
    }

    @Override
    public float getSize(float min, float max) {
        float result = 0.0f;
        if (ModConfig.biasSizeTowardAverage) {
            for (int i = 0; i < 3; ++i) {
                int value = RNG.nextInt(0, 255);
                result += (min + (float)value / 255.0f * (max - min)) / 3.0f;
            }
        } else {
            int value = RNG.nextInt(0, 255);
            result = min + (float)value / 255.0f * (max - min);
        }
        return result;
    }

    @Override
    public Size getSizeInformation(float size) {
        int value = this.convertSizeToInt(size);
        List<Size> sizeDefinitions = this.sizeDefinition.getSizes();
        if (size > this.maxSizeModifier) {
            return sizeDefinitions.getLast();
        }
        if (size < this.minSizeModifier) {
            return sizeDefinitions.getFirst();
        }
        for (Size s : sizeDefinitions) {
            if (value < Integer.parseInt(s.min()) || value > Integer.parseInt(s.max())) continue;
            return s;
        }
        return null;
    }

    @Override
    public float getMinSizeModifier() {
        return this.minSizeModifier;
    }

    @Override
    public float getMaxSizeModifier() {
        return this.maxSizeModifier;
    }

    private int convertSizeToInt(float size) {
        float a = (this.maxSizeModifier - this.minSizeModifier) / 255.0f;
        float b = size - this.minSizeModifier;
        float x = b / a;
        return (int)x;
    }

    public static JsonElement createConfig(Path sizeFile) {
        JsonObject configuration;
        JsonObject defaultConfiguration = new JsonObject();
        GenIXSizer.addDefaultFields(defaultConfiguration);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            configuration = JsonParser.parseReader((Reader)new FileReader(sizeFile.toString())).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            configuration = FileUtils.createFile(gson, defaultConfiguration, sizeFile);
        }
        if (configuration != null) {
            return configuration;
        }
        CobblemonSizeVariation.LOGGER.error("File for gen9 sizer was not created.");
        throw new RuntimeException("The configured size algorithm was not loaded correctly");
    }

    private static void addDefaultFields(JsonObject defaultConfig) {
        defaultConfig.addProperty("name", "gen9");
        defaultConfig.addProperty("minSizeModifier", "0.2");
        defaultConfig.addProperty("maxSizeModifier", "2.0");
        defaultConfig.add("sizes", (JsonElement)GenIXSizer.generateDefaultSizeDefinitions());
    }

    private static JsonArray generateDefaultSizeDefinitions() {
        JsonArray sizeDefinitions = new JsonArray();
        JsonObject xxxsDefinition = new JsonObject();
        xxxsDefinition.addProperty("name", "XXXS");
        xxxsDefinition.addProperty("min", "0");
        xxxsDefinition.addProperty("max", "0");
        xxxsDefinition.addProperty("color", "#1b88cc");
        sizeDefinitions.add((JsonElement)xxxsDefinition);
        JsonObject xxsDefinition = new JsonObject();
        xxsDefinition.addProperty("name", "XXS");
        xxsDefinition.addProperty("min", "1");
        xxsDefinition.addProperty("max", "24");
        xxsDefinition.addProperty("color", "#1b88cc");
        sizeDefinitions.add((JsonElement)xxsDefinition);
        JsonObject xsDefinition = new JsonObject();
        xsDefinition.addProperty("name", "XS");
        xsDefinition.addProperty("min", "25");
        xsDefinition.addProperty("max", "59");
        xsDefinition.addProperty("color", "#1b88cc");
        sizeDefinitions.add((JsonElement)xsDefinition);
        JsonObject sDefinition = new JsonObject();
        sDefinition.addProperty("name", "S");
        sDefinition.addProperty("min", "60");
        sDefinition.addProperty("max", "99");
        sDefinition.addProperty("color", "#1bcc9a");
        sizeDefinitions.add((JsonElement)sDefinition);
        JsonObject mDefinition = new JsonObject();
        mDefinition.addProperty("name", "M");
        mDefinition.addProperty("min", "100");
        mDefinition.addProperty("max", "155");
        mDefinition.addProperty("color", "#ffffff");
        sizeDefinitions.add((JsonElement)mDefinition);
        JsonObject lDefinition = new JsonObject();
        lDefinition.addProperty("name", "L");
        lDefinition.addProperty("min", "156");
        lDefinition.addProperty("max", "195");
        lDefinition.addProperty("color", "#e6ff2b");
        sizeDefinitions.add((JsonElement)lDefinition);
        JsonObject xlDefinition = new JsonObject();
        xlDefinition.addProperty("name", "XL");
        xlDefinition.addProperty("min", "196");
        xlDefinition.addProperty("max", "230");
        xlDefinition.addProperty("color", "#f21800");
        sizeDefinitions.add((JsonElement)xlDefinition);
        JsonObject xxlDefinition = new JsonObject();
        xxlDefinition.addProperty("name", "XXL");
        xxlDefinition.addProperty("min", "231");
        xxlDefinition.addProperty("max", "254");
        xxlDefinition.addProperty("color", "#f21800");
        sizeDefinitions.add((JsonElement)xxlDefinition);
        JsonObject xxxlDefinition = new JsonObject();
        xxxlDefinition.addProperty("name", "XXXL");
        xxxlDefinition.addProperty("min", "255");
        xxxlDefinition.addProperty("max", "255");
        xxxlDefinition.addProperty("color", "#f21800");
        sizeDefinitions.add((JsonElement)xxxlDefinition);
        return sizeDefinitions;
    }
}

