/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

public class ModConfig {
    private static final String configFileLoc = "cobblemonsizevariation/config.json";
    public static float preventShoulderMountSize;
    public static float preventRidingMinSize;
    public static float preventRidingMaxSize;
    public static float sizeModificationChance;
    public static String sizingAlgorithm;
    public static boolean biasSizeTowardAverage;
    public static boolean enableEssenceRecipes;
    public static HashMap<String, Integer> perms;
    private static Path fullPath;

    public static void init(Path platformConfigDirectory) {
        JsonObject configuration;
        fullPath = platformConfigDirectory.resolve(configFileLoc);
        JsonObject defaultConfiguration = new JsonObject();
        ModConfig.addDefaultFields(defaultConfiguration);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            configuration = JsonParser.parseReader((Reader)new FileReader(fullPath.toString())).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            CobblemonSizeVariation.LOGGER.warn("Could not find configuration file");
            configuration = new JsonObject();
        }
        JsonObject finalConfiguration = configuration;
        if (defaultConfiguration.keySet().stream().anyMatch(k -> !finalConfiguration.has(k)) || finalConfiguration.keySet().stream().anyMatch(k -> !defaultConfiguration.has(k))) {
            ModConfig.rewriteConfig(gson, defaultConfiguration, finalConfiguration);
        }
        ModConfig.loadConfig(finalConfiguration);
    }

    private static void addDefaultFields(JsonObject defaultConfig) {
        defaultConfig.addProperty("sizeModificationChance", (Number)Float.valueOf(0.5f));
        defaultConfig.addProperty("preventShoulderMountSize", (Number)Float.valueOf(1.5f));
        defaultConfig.addProperty("preventRidingMinSize", (Number)Float.valueOf(0.3f));
        defaultConfig.addProperty("preventRidingMaxSize", (Number)Float.valueOf(1.8f));
        defaultConfig.add("permissions", (JsonElement)ModConfig.generateDefaultPermissions());
        defaultConfig.addProperty("sizingAlgorithm", "basic");
        defaultConfig.addProperty("biasSizeTowardAverage", Boolean.valueOf(false));
        defaultConfig.addProperty("enableEssenceRecipes", Boolean.valueOf(false));
    }

    private static void rewriteConfig(Gson gson, JsonObject defaultConfig, JsonObject finalConfig) {
        defaultConfig.keySet().stream().filter(k -> !finalConfig.has(k)).forEach(k -> {
            CobblemonSizeVariation.LOGGER.info("Adding new field '{}' to the config", k);
            finalConfig.add(k, defaultConfig.get(k));
        });
        try {
            Files.createDirectories(Paths.get(fullPath.toString(), new String[0]).getParent(), new FileAttribute[0]);
            FileWriter writer = new FileWriter(fullPath.toString());
            gson.toJson((JsonElement)finalConfig, (Appendable)writer);
            writer.close();
        }
        catch (IOException ioException) {
            CobblemonSizeVariation.LOGGER.warn("Could not create new config");
        }
    }

    private static void loadConfig(JsonObject finalConfiguration) {
        sizeModificationChance = finalConfiguration.get("sizeModificationChance").getAsFloat();
        preventShoulderMountSize = finalConfiguration.get("preventShoulderMountSize").getAsFloat();
        preventRidingMinSize = finalConfiguration.get("preventRidingMinSize").getAsFloat();
        preventRidingMaxSize = finalConfiguration.get("preventRidingMaxSize").getAsFloat();
        sizingAlgorithm = finalConfiguration.get("sizingAlgorithm").getAsString();
        biasSizeTowardAverage = finalConfiguration.get("biasSizeTowardAverage").getAsBoolean();
        enableEssenceRecipes = finalConfiguration.get("enableEssenceRecipes").getAsBoolean();
        JsonArray permissionConfig = finalConfiguration.get("permissions").getAsJsonArray();
        perms.clear();
        permissionConfig.iterator().forEachRemaining(element -> {
            JsonObject permObj = element.getAsJsonObject();
            if (permObj.has("cobblemonsizevariation.command.pokesizer")) {
                perms.put("cobblemonsizevariation.command.pokesizer", permObj.get("cobblemonsizevariation.command.pokesizer").getAsInt());
            }
            if (permObj.has("cobblemonsizevariation.command.pokesizer.self")) {
                perms.put("cobblemonsizevariation.command.pokesizer.self", permObj.get("cobblemonsizevariation.command.pokesizer.self").getAsInt());
            }
        });
    }

    public static int getPermission(String permKey) {
        return perms.getOrDefault(permKey, 0);
    }

    private static JsonArray generateDefaultPermissions() {
        JsonArray perms = new JsonArray();
        JsonObject pokesizerPerm = new JsonObject();
        pokesizerPerm.addProperty("cobblemonsizevariation.command.pokesizer", (Number)2);
        perms.add((JsonElement)pokesizerPerm);
        JsonObject pokesizerSelfPerm = new JsonObject();
        pokesizerSelfPerm.addProperty("cobblemonsizevariation.command.pokesizer.self", (Number)2);
        perms.add((JsonElement)pokesizerSelfPerm);
        return perms;
    }

    static {
        perms = new HashMap();
    }
}

