/*
 * Decompiled with CFR 0.152.
 */
package com.etema.attributemodify;

import com.etema.attributemodify.AttributeModify;
import com.etema.attributemodify.ItemAttributeDataManager;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class CuriosAttributeModifier {
    public static void modifyAttributes(ItemStack itemStack, String slotIdentifier, Multimap<Attribute, AttributeModifier> attributeMap) {
        if (!ModList.get().isLoaded("curios")) {
            return;
        }
        if (itemStack.m_41619_()) {
            return;
        }
        try {
            ItemAttributeDataManager dataManager = ItemAttributeDataManager.getInstance();
            if (!dataManager.hasCustomAttributes(itemStack.m_41720_())) {
                return;
            }
            Set<Attribute> attributesToRemove = dataManager.getRemovedAttributesForCuriosSlot(itemStack.m_41720_(), slotIdentifier);
            for (Attribute attribute : attributesToRemove) {
                attributeMap.removeAll((Object)attribute);
                AttributeModify.LOGGER.debug("Removed attribute {} from {} in slot {}", new Object[]{attribute.m_22087_(), itemStack.m_41720_(), slotIdentifier});
            }
            Map<Attribute, AttributeModifier> attributesToAdd = dataManager.getAttributesForCuriosSlot(itemStack.m_41720_(), slotIdentifier);
            for (Map.Entry<Attribute, AttributeModifier> entry : attributesToAdd.entrySet()) {
                attributeMap.removeAll((Object)entry.getKey());
                attributeMap.put((Object)entry.getKey(), (Object)entry.getValue());
                AttributeModify.LOGGER.debug("Added attribute {} to {} in slot {}", new Object[]{entry.getKey().m_22087_(), itemStack.m_41720_(), slotIdentifier});
            }
        }
        catch (Exception e) {
            AttributeModify.LOGGER.debug("Error modifying Curios attributes: {}", (Object)e.getMessage());
        }
    }

    public static boolean shouldProcess(ItemStack itemStack, String slotIdentifier) {
        if (!ModList.get().isLoaded("curios")) {
            return false;
        }
        if (itemStack.m_41619_()) {
            return false;
        }
        ItemAttributeDataManager dataManager = ItemAttributeDataManager.getInstance();
        return dataManager.hasCustomAttributes(itemStack.m_41720_()) && (dataManager.getAttributesForCuriosSlot(itemStack.m_41720_(), slotIdentifier).size() > 0 || dataManager.getRemovedAttributesForCuriosSlot(itemStack.m_41720_(), slotIdentifier).size() > 0);
    }
}

