/*
 * Decompiled with CFR 0.152.
 */
package com.etema.attributemodify;

import com.etema.attributemodify.AttributeModify;
import com.etema.attributemodify.ItemAttributeDataManager;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;

@Mod.EventBusSubscriber(modid="attributemodify", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CuriosIntegration {
    private static boolean curiosLoaded = false;

    public static void initialize() {
        curiosLoaded = ModList.get().isLoaded("curios");
        if (curiosLoaded) {
            AttributeModify.LOGGER.info("Curios detected - direct event integration enabled");
        } else {
            AttributeModify.LOGGER.info("Curios not found - standard slots only");
        }
    }

    public static boolean isCuriosLoaded() {
        return curiosLoaded;
    }

    @SubscribeEvent
    public static void onCurioAttributeModifierEvent(CurioAttributeModifierEvent event) {
        if (!curiosLoaded) {
            return;
        }
        try {
            ItemStack itemStack = event.getItemStack();
            if (itemStack.m_41619_()) {
                return;
            }
            String slotIdentifier = event.getSlotContext().identifier();
            AttributeModify.LOGGER.info("Processing Curios attributes for {} in slot {}", (Object)itemStack.m_41720_(), (Object)slotIdentifier);
            ItemAttributeDataManager dataManager = ItemAttributeDataManager.getInstance();
            if (!dataManager.hasCustomAttributes(itemStack.m_41720_())) {
                return;
            }
            Set<Attribute> attributesToRemove = dataManager.getRemovedAttributesForCuriosSlot(itemStack.m_41720_(), slotIdentifier);
            for (Attribute attribute : attributesToRemove) {
                event.removeAttribute(attribute);
                AttributeModify.LOGGER.info("Removed Curios attribute {} from {} in slot {}", new Object[]{attribute.m_22087_(), itemStack.m_41720_(), slotIdentifier});
            }
            Map<Attribute, AttributeModifier> attributesToAdd = dataManager.getAttributesForCuriosSlot(itemStack.m_41720_(), slotIdentifier);
            for (Map.Entry<Attribute, AttributeModifier> entry : attributesToAdd.entrySet()) {
                event.removeAttribute(entry.getKey());
                event.addModifier(entry.getKey(), entry.getValue());
                AttributeModify.LOGGER.info("Added/Modified Curios attribute {} on {} in slot {}", new Object[]{entry.getKey().m_22087_(), itemStack.m_41720_(), slotIdentifier});
            }
        }
        catch (Exception e) {
            AttributeModify.LOGGER.error("Error processing Curios event: {}", (Object)e.getMessage());
        }
    }
}

