/*
 * Decompiled with CFR 0.152.
 */
package com.etema.attributemodify;

import com.etema.attributemodify.CuriosIntegration;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class ItemAttributeDataManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ItemAttributeDataManager instance;
    private final Map<Item, Map<EquipmentSlot, List<AttributeEntry>>> itemAttributes = new HashMap<Item, Map<EquipmentSlot, List<AttributeEntry>>>();
    private final Map<Item, Map<String, List<AttributeEntry>>> curiosAttributes = new HashMap<Item, Map<String, List<AttributeEntry>>>();

    public ItemAttributeDataManager() {
        super(GSON, "item_attributes");
        instance = this;
    }

    public static ItemAttributeDataManager getInstance() {
        if (instance == null) {
            instance = new ItemAttributeDataManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.itemAttributes.clear();
        this.curiosAttributes.clear();
        int loadedFiles = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceMap.entrySet()) {
            ResourceLocation location = entry.getKey();
            try {
                JsonObject json = entry.getValue().getAsJsonObject();
                this.processAttributeFile(json, location);
                ++loadedFiles;
            }
            catch (Exception e) {
                LOGGER.error("Error loading attribute file {}: {}", (Object)location, (Object)e.getMessage());
            }
        }
        LOGGER.info("AttributeModify - Loaded {} attribute files with {} item configurations", (Object)loadedFiles, (Object)(this.itemAttributes.size() + this.curiosAttributes.size()));
    }

    private void processAttributeFile(JsonObject json, ResourceLocation location) {
        for (Map.Entry itemEntry : json.entrySet()) {
            String itemId = (String)itemEntry.getKey();
            ResourceLocation itemLocation = new ResourceLocation(itemId);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            if (item == null) {
                LOGGER.warn("Item {} not found in registry", (Object)itemId);
                continue;
            }
            JsonObject itemData = ((JsonElement)itemEntry.getValue()).getAsJsonObject();
            this.processItemAttributes(item, itemData);
        }
    }

    private void processItemAttributes(Item item, JsonObject itemData) {
        if (itemData.has("equipment_slots")) {
            JsonObject slotsData = itemData.getAsJsonObject("equipment_slots");
            for (Map.Entry slotEntry : slotsData.entrySet()) {
                String slotName = ((String)slotEntry.getKey()).toLowerCase();
                EquipmentSlot slot = this.parseEquipmentSlot(slotName);
                if (slot == null) continue;
                JsonArray attributesArray = ((JsonElement)slotEntry.getValue()).getAsJsonArray();
                List<AttributeEntry> attributes = this.parseAttributeEntries(attributesArray);
                this.itemAttributes.computeIfAbsent(item, k -> new HashMap()).put(slot, attributes);
            }
        }
        if (itemData.has("curios_slots") && CuriosIntegration.isCuriosLoaded()) {
            try {
                JsonObject curiosData = itemData.getAsJsonObject("curios_slots");
                for (Map.Entry curiosEntry : curiosData.entrySet()) {
                    String curiosSlot = (String)curiosEntry.getKey();
                    JsonArray attributesArray = ((JsonElement)curiosEntry.getValue()).getAsJsonArray();
                    List<AttributeEntry> attributes = this.parseAttributeEntries(attributesArray);
                    this.curiosAttributes.computeIfAbsent(item, k -> new HashMap()).put(curiosSlot, attributes);
                    LOGGER.debug("Processed Curios slot '{}' for item {}", (Object)curiosSlot, (Object)ForgeRegistries.ITEMS.getKey((Object)item));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing Curios slots for item {}: {}", (Object)ForgeRegistries.ITEMS.getKey((Object)item), (Object)e.getMessage());
            }
        }
    }

    private List<AttributeEntry> parseAttributeEntries(JsonArray attributesArray) {
        ArrayList<AttributeEntry> entries = new ArrayList<AttributeEntry>();
        for (JsonElement element : attributesArray) {
            JsonObject attrObj = element.getAsJsonObject();
            try {
                String attributeId = attrObj.get("attribute").getAsString();
                String action = attrObj.get("action").getAsString();
                ResourceLocation attrLocation = new ResourceLocation(attributeId);
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attrLocation);
                if (attribute == null) {
                    LOGGER.warn("Attribute {} not found", (Object)attributeId);
                    continue;
                }
                if ("remove".equals(action)) {
                    entries.add(new AttributeEntry(attribute, null, action));
                    continue;
                }
                Object modifierName = attrObj.has("name") ? attrObj.get("name").getAsString() : "attributemodify." + attribute.m_22087_();
                double amount = attrObj.get("amount").getAsDouble();
                AttributeModifier.Operation operation = this.parseOperation(attrObj.get("operation").getAsString());
                UUID uuid = attrObj.has("uuid") ? UUID.fromString(attrObj.get("uuid").getAsString()) : UUID.nameUUIDFromBytes(((String)modifierName + attribute.m_22087_() + amount + operation.toString()).getBytes());
                AttributeModifier modifier = new AttributeModifier(uuid, (String)modifierName, amount, operation);
                entries.add(new AttributeEntry(attribute, modifier, action));
            }
            catch (Exception e) {
                LOGGER.error("Error parsing attribute entry: {}", (Object)e.getMessage());
            }
        }
        return entries;
    }

    private EquipmentSlot parseEquipmentSlot(String slotName) {
        return switch (slotName) {
            case "mainhand" -> EquipmentSlot.MAINHAND;
            case "offhand" -> EquipmentSlot.OFFHAND;
            case "feet" -> EquipmentSlot.FEET;
            case "legs" -> EquipmentSlot.LEGS;
            case "chest" -> EquipmentSlot.CHEST;
            case "head" -> EquipmentSlot.HEAD;
            default -> null;
        };
    }

    private AttributeModifier.Operation parseOperation(String operationName) {
        return switch (operationName.toLowerCase()) {
            case "addition", "add" -> AttributeModifier.Operation.ADDITION;
            case "multiply_base", "multiply" -> AttributeModifier.Operation.MULTIPLY_BASE;
            case "multiply_total" -> AttributeModifier.Operation.MULTIPLY_TOTAL;
            default -> AttributeModifier.Operation.ADDITION;
        };
    }

    public Map<Attribute, AttributeModifier> getAttributesForSlot(Item item, EquipmentSlot slot) {
        HashMap<Attribute, AttributeModifier> result = new HashMap<Attribute, AttributeModifier>();
        Map<EquipmentSlot, List<AttributeEntry>> itemData = this.itemAttributes.get(item);
        if (itemData != null && itemData.containsKey(slot)) {
            for (AttributeEntry entry : itemData.get(slot)) {
                if (!"add".equals(entry.action) && !"modify".equals(entry.action)) continue;
                result.put(entry.attribute, entry.modifier);
            }
        }
        return result;
    }

    public Map<Attribute, AttributeModifier> getAttributesForCuriosSlot(Item item, String curiosSlot) {
        HashMap<Attribute, AttributeModifier> result = new HashMap<Attribute, AttributeModifier>();
        Map<String, List<AttributeEntry>> itemData = this.curiosAttributes.get(item);
        if (itemData != null && itemData.containsKey(curiosSlot)) {
            for (AttributeEntry entry : itemData.get(curiosSlot)) {
                if (!"add".equals(entry.action) && !"modify".equals(entry.action)) continue;
                result.put(entry.attribute, entry.modifier);
            }
        }
        return result;
    }

    public Set<Attribute> getRemovedAttributesForSlot(Item item, EquipmentSlot slot) {
        HashSet<Attribute> result = new HashSet<Attribute>();
        Map<EquipmentSlot, List<AttributeEntry>> itemData = this.itemAttributes.get(item);
        if (itemData != null && itemData.containsKey(slot)) {
            for (AttributeEntry entry : itemData.get(slot)) {
                if (!"remove".equals(entry.action)) continue;
                result.add(entry.attribute);
            }
        }
        return result;
    }

    public Set<Attribute> getRemovedAttributesForCuriosSlot(Item item, String curiosSlot) {
        HashSet<Attribute> result = new HashSet<Attribute>();
        Map<String, List<AttributeEntry>> itemData = this.curiosAttributes.get(item);
        if (itemData != null && itemData.containsKey(curiosSlot)) {
            for (AttributeEntry entry : itemData.get(curiosSlot)) {
                if (!"remove".equals(entry.action)) continue;
                result.add(entry.attribute);
            }
        }
        return result;
    }

    public boolean hasCustomAttributes(Item item) {
        return this.itemAttributes.containsKey(item) || this.curiosAttributes.containsKey(item);
    }

    public Map<Item, Map<EquipmentSlot, List<AttributeEntry>>> getStandardAttributesForSync() {
        return new HashMap<Item, Map<EquipmentSlot, List<AttributeEntry>>>(this.itemAttributes);
    }

    public Map<Item, Map<String, List<AttributeEntry>>> getCuriosAttributesForSync() {
        return new HashMap<Item, Map<String, List<AttributeEntry>>>(this.curiosAttributes);
    }

    public void updateFromServer(Map<Item, Map<EquipmentSlot, List<AttributeEntry>>> standardData, Map<Item, Map<String, List<AttributeEntry>>> curiosData) {
        this.itemAttributes.clear();
        this.curiosAttributes.clear();
        this.itemAttributes.putAll(standardData);
        this.curiosAttributes.putAll(curiosData);
        LOGGER.info("Updated client data: {} standard items, {} curios items", (Object)standardData.size(), (Object)curiosData.size());
    }

    public static class AttributeEntry {
        public Attribute attribute;
        public AttributeModifier modifier;
        public String action;

        public AttributeEntry(Attribute attribute, AttributeModifier modifier, String action) {
            this.attribute = attribute;
            this.modifier = modifier;
            this.action = action;
        }
    }
}

