/*
 * Decompiled with CFR 0.152.
 */
package com.etema.attributemodify;

import com.etema.attributemodify.ItemAttributeDataManager;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class ItemAttributeHandler {
    @SubscribeEvent
    public void onItemAttributeModifier(ItemAttributeModifierEvent event) {
        try {
            ItemStack itemStack = event.getItemStack();
            EquipmentSlot slot = event.getSlotType();
            if (itemStack.m_41619_()) {
                return;
            }
            ItemAttributeDataManager dataManager = ItemAttributeDataManager.getInstance();
            if (!dataManager.hasCustomAttributes(itemStack.m_41720_())) {
                return;
            }
            Set<Attribute> attributesToRemove = dataManager.getRemovedAttributesForSlot(itemStack.m_41720_(), slot);
            for (Attribute attribute : attributesToRemove) {
                event.removeAttribute(attribute);
            }
            Map<Attribute, AttributeModifier> attributesToAdd = dataManager.getAttributesForSlot(itemStack.m_41720_(), slot);
            for (Map.Entry<Attribute, AttributeModifier> entry : attributesToAdd.entrySet()) {
                if ("modify".equals(entry.getValue().m_22214_())) {
                    event.removeAttribute(entry.getKey());
                }
                event.addModifier(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleCuriosAttributes(ItemStack itemStack, String curiosSlot, Multimap<Attribute, AttributeModifier> modifiers) {
        if (!ModList.get().isLoaded("curios")) {
            return;
        }
        try {
            ItemAttributeDataManager dataManager = ItemAttributeDataManager.getInstance();
            if (!dataManager.hasCustomAttributes(itemStack.m_41720_())) {
                return;
            }
            Set<Attribute> attributesToRemove = dataManager.getRemovedAttributesForCuriosSlot(itemStack.m_41720_(), curiosSlot);
            for (Attribute attribute : attributesToRemove) {
                modifiers.removeAll((Object)attribute);
            }
            Map<Attribute, AttributeModifier> attributesToAdd = dataManager.getAttributesForCuriosSlot(itemStack.m_41720_(), curiosSlot);
            for (Map.Entry<Attribute, AttributeModifier> entry : attributesToAdd.entrySet()) {
                modifiers.removeAll((Object)entry.getKey());
                modifiers.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

