/*
 * Decompiled with CFR 0.152.
 */
package com.etema.attributemodify.network;

import com.etema.attributemodify.AttributeModify;
import com.etema.attributemodify.ItemAttributeDataManager;
import com.etema.attributemodify.network.NetworkHandler;
import com.etema.attributemodify.network.SyncAttributeDataPacket;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="attributemodify", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NetworkEventHandler {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AttributeModify.LOGGER.info("Player {} logged in, syncing attribute data", (Object)serverPlayer.m_7755_().getString());
            serverPlayer.m_20194_().execute(() -> NetworkEventHandler.sendDataToPlayer(serverPlayer));
        }
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        AttributeModify.LOGGER.info("Datapack sync event triggered");
        if (event.getPlayer() != null) {
            NetworkEventHandler.sendDataToPlayer(event.getPlayer());
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                NetworkEventHandler.sendDataToPlayer(player);
            }
        }
    }

    private static void sendDataToPlayer(ServerPlayer player) {
        try {
            ItemAttributeDataManager dataManager = ItemAttributeDataManager.getInstance();
            Map<Item, Map<EquipmentSlot, List<ItemAttributeDataManager.AttributeEntry>>> standardData = dataManager.getStandardAttributesForSync();
            Map<Item, Map<String, List<ItemAttributeDataManager.AttributeEntry>>> curiosData = dataManager.getCuriosAttributesForSync();
            if (!standardData.isEmpty() || !curiosData.isEmpty()) {
                SyncAttributeDataPacket packet = new SyncAttributeDataPacket(standardData, curiosData);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
                AttributeModify.LOGGER.debug("Sent attribute data to player {}: {} standard, {} curios", new Object[]{player.m_7755_().getString(), standardData.size(), curiosData.size()});
            }
        }
        catch (Exception e) {
            AttributeModify.LOGGER.error("Failed to send attribute data to player {}: {}", (Object)player.m_7755_().getString(), (Object)e.getMessage());
        }
    }
}

