/*
 * Decompiled with CFR 0.152.
 */
package com.etema.attributemodify.network;

import com.etema.attributemodify.AttributeModify;
import com.etema.attributemodify.ItemAttributeDataManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SyncAttributeDataPacket {
    private final Map<Item, Map<EquipmentSlot, List<AttributeEntry>>> standardAttributes;
    private final Map<Item, Map<String, List<AttributeEntry>>> curiosAttributes;
    private Map<Item, Map<EquipmentSlot, List<ItemAttributeDataManager.AttributeEntry>>> decodedStandardAttributes;
    private Map<Item, Map<String, List<ItemAttributeDataManager.AttributeEntry>>> decodedCuriosAttributes;

    public SyncAttributeDataPacket(Map<Item, Map<EquipmentSlot, List<ItemAttributeDataManager.AttributeEntry>>> standard, Map<Item, Map<String, List<ItemAttributeDataManager.AttributeEntry>>> curios) {
        ArrayList<AttributeEntry> entries;
        HashMap slots;
        this.standardAttributes = new HashMap<Item, Map<EquipmentSlot, List<AttributeEntry>>>();
        this.curiosAttributes = new HashMap<Item, Map<String, List<AttributeEntry>>>();
        for (Map.Entry<Item, Map<EquipmentSlot, List<ItemAttributeDataManager.AttributeEntry>>> entry : standard.entrySet()) {
            slots = new HashMap();
            for (Map.Entry<EquipmentSlot, List<ItemAttributeDataManager.AttributeEntry>> entry2 : entry.getValue().entrySet()) {
                entries = new ArrayList<AttributeEntry>();
                for (ItemAttributeDataManager.AttributeEntry attr : entry2.getValue()) {
                    entries.add(new AttributeEntry(attr.action, attr.attribute, attr.modifier));
                }
                slots.put(entry2.getKey(), entries);
            }
            this.standardAttributes.put(entry.getKey(), slots);
        }
        for (Map.Entry<Item, Map<Object, List<ItemAttributeDataManager.AttributeEntry>>> entry : curios.entrySet()) {
            slots = new HashMap();
            for (Map.Entry<Object, List<ItemAttributeDataManager.AttributeEntry>> entry3 : entry.getValue().entrySet()) {
                entries = new ArrayList();
                for (ItemAttributeDataManager.AttributeEntry attr : entry3.getValue()) {
                    entries.add(new AttributeEntry(attr.action, attr.attribute, attr.modifier));
                }
                slots.put((String)entry3.getKey(), entries);
            }
            this.curiosAttributes.put(entry.getKey(), slots);
        }
    }

    private SyncAttributeDataPacket() {
        this.standardAttributes = null;
        this.curiosAttributes = null;
    }

    public static void encode(SyncAttributeDataPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.standardAttributes.size());
        for (Map.Entry<Item, Map<EquipmentSlot, List<AttributeEntry>>> entry : packet.standardAttributes.entrySet()) {
            buf.m_130085_(ForgeRegistries.ITEMS.getKey((Object)entry.getKey()));
            buf.writeInt(entry.getValue().size());
            for (Map.Entry<Object, List<AttributeEntry>> slotEntry : entry.getValue().entrySet()) {
                buf.m_130068_((Enum)slotEntry.getKey());
                buf.writeInt(slotEntry.getValue().size());
                for (AttributeEntry attr : slotEntry.getValue()) {
                    buf.m_130070_(attr.action);
                    buf.m_130085_(ForgeRegistries.ATTRIBUTES.getKey((Object)attr.attribute));
                    if (attr.modifier != null) {
                        buf.writeBoolean(true);
                        buf.m_130077_(attr.modifier.m_22209_());
                        buf.m_130070_(attr.modifier.m_22214_());
                        buf.writeDouble(attr.modifier.m_22218_());
                        buf.m_130068_((Enum)attr.modifier.m_22217_());
                        continue;
                    }
                    buf.writeBoolean(false);
                }
            }
        }
        buf.writeInt(packet.curiosAttributes.size());
        for (Map.Entry<Item, Map<Object, List<AttributeEntry>>> entry : packet.curiosAttributes.entrySet()) {
            buf.m_130085_(ForgeRegistries.ITEMS.getKey((Object)entry.getKey()));
            buf.writeInt(entry.getValue().size());
            for (Map.Entry<Object, List<AttributeEntry>> slotEntry : entry.getValue().entrySet()) {
                buf.m_130070_((String)slotEntry.getKey());
                buf.writeInt(slotEntry.getValue().size());
                for (AttributeEntry attr : slotEntry.getValue()) {
                    buf.m_130070_(attr.action);
                    buf.m_130085_(ForgeRegistries.ATTRIBUTES.getKey((Object)attr.attribute));
                    if (attr.modifier != null) {
                        buf.writeBoolean(true);
                        buf.m_130077_(attr.modifier.m_22209_());
                        buf.m_130070_(attr.modifier.m_22214_());
                        buf.writeDouble(attr.modifier.m_22218_());
                        buf.m_130068_((Enum)attr.modifier.m_22217_());
                        continue;
                    }
                    buf.writeBoolean(false);
                }
            }
        }
    }

    public static SyncAttributeDataPacket decode(FriendlyByteBuf buf) {
        HashMap<Item, Map<EquipmentSlot, List<ItemAttributeDataManager.AttributeEntry>>> standard = new HashMap<Item, Map<EquipmentSlot, List<ItemAttributeDataManager.AttributeEntry>>>();
        HashMap<Item, Map<String, List<ItemAttributeDataManager.AttributeEntry>>> curios = new HashMap<Item, Map<String, List<ItemAttributeDataManager.AttributeEntry>>>();
        int standardSize = buf.readInt();
        for (int i = 0; i < standardSize; ++i) {
            ResourceLocation itemLoc = buf.m_130281_();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLoc);
            int slotsSize = buf.readInt();
            HashMap slots = new HashMap();
            for (int j = 0; j < slotsSize; ++j) {
                EquipmentSlot slot = (EquipmentSlot)buf.m_130066_(EquipmentSlot.class);
                int attrsSize = buf.readInt();
                ArrayList<ItemAttributeDataManager.AttributeEntry> entries = new ArrayList<ItemAttributeDataManager.AttributeEntry>();
                for (int k = 0; k < attrsSize; ++k) {
                    String action = buf.m_130277_();
                    ResourceLocation attrLoc = buf.m_130281_();
                    Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attrLoc);
                    AttributeModifier modifier = null;
                    if (buf.readBoolean()) {
                        UUID id = buf.m_130259_();
                        String name = buf.m_130277_();
                        double amount = buf.readDouble();
                        AttributeModifier.Operation operation = (AttributeModifier.Operation)buf.m_130066_(AttributeModifier.Operation.class);
                        modifier = new AttributeModifier(id, name, amount, operation);
                    }
                    entries.add(new ItemAttributeDataManager.AttributeEntry(attr, modifier, action));
                }
                slots.put(slot, entries);
            }
            standard.put(item, slots);
        }
        int curiosSize = buf.readInt();
        for (int i = 0; i < curiosSize; ++i) {
            ResourceLocation itemLoc = buf.m_130281_();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLoc);
            int slotsSize = buf.readInt();
            HashMap slots = new HashMap();
            for (int j = 0; j < slotsSize; ++j) {
                String slotName = buf.m_130277_();
                int attrsSize = buf.readInt();
                ArrayList<ItemAttributeDataManager.AttributeEntry> entries = new ArrayList<ItemAttributeDataManager.AttributeEntry>();
                for (int k = 0; k < attrsSize; ++k) {
                    String action = buf.m_130277_();
                    ResourceLocation attrLoc = buf.m_130281_();
                    Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attrLoc);
                    AttributeModifier modifier = null;
                    if (buf.readBoolean()) {
                        UUID id = buf.m_130259_();
                        String name = buf.m_130277_();
                        double amount = buf.readDouble();
                        AttributeModifier.Operation operation = (AttributeModifier.Operation)buf.m_130066_(AttributeModifier.Operation.class);
                        modifier = new AttributeModifier(id, name, amount, operation);
                    }
                    entries.add(new ItemAttributeDataManager.AttributeEntry(attr, modifier, action));
                }
                slots.put(slotName, entries);
            }
            curios.put(item, slots);
        }
        SyncAttributeDataPacket packet = new SyncAttributeDataPacket();
        packet.decodedStandardAttributes = standard;
        packet.decodedCuriosAttributes = curios;
        return packet;
    }

    public static void handle(SyncAttributeDataPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ItemAttributeDataManager.getInstance().updateFromServer(packet.decodedStandardAttributes, packet.decodedCuriosAttributes);
            AttributeModify.LOGGER.info("Client synchronized attribute data from server");
        });
        context.setPacketHandled(true);
    }

    public static class AttributeEntry {
        public String action;
        public Attribute attribute;
        public AttributeModifier modifier;

        public AttributeEntry(String action, Attribute attribute, AttributeModifier modifier) {
            this.action = action;
            this.attribute = attribute;
            this.modifier = modifier;
        }
    }
}

