/*
 * Decompiled with CFR 0.152.
 */
package com.etema.attributemodify;

import com.etema.attributemodify.AttributeModify;
import com.etema.attributemodify.ItemAttributeDataManager;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;

public class CuriosEventHandler {
    @SubscribeEvent
    public void onCurioAttributeModifierEvent(CurioAttributeModifierEvent event) {
        try {
            ItemStack itemStack = event.getItemStack();
            if (itemStack.m_41619_()) {
                return;
            }
            String slotIdentifier = event.getSlotContext().identifier();
            AttributeModify.LOGGER.debug("Processing Curios attributes for {} in slot {}", (Object)itemStack.m_41720_().toString(), (Object)slotIdentifier);
            ItemAttributeDataManager dataManager = ItemAttributeDataManager.getInstance();
            if (!dataManager.hasCustomAttributes(itemStack.m_41720_())) {
                return;
            }
            Set<Attribute> attributesToRemove = dataManager.getRemovedAttributesForCuriosSlot(itemStack.m_41720_(), slotIdentifier);
            for (Attribute attribute : attributesToRemove) {
                event.removeAttribute(attribute);
                AttributeModify.LOGGER.debug("Removed Curios attribute {} from {} in slot {}", new Object[]{attribute.m_22087_(), itemStack.m_41720_().toString(), slotIdentifier});
            }
            Map<Attribute, AttributeModifier> attributesToAdd = dataManager.getAttributesForCuriosSlot(itemStack.m_41720_(), slotIdentifier);
            for (Map.Entry<Attribute, AttributeModifier> entry : attributesToAdd.entrySet()) {
                event.removeAttribute(entry.getKey());
                event.addModifier(entry.getKey(), entry.getValue());
                AttributeModify.LOGGER.debug("Added/Modified Curios attribute {} on {} in slot {}", new Object[]{entry.getKey().m_22087_(), itemStack.m_41720_().toString(), slotIdentifier});
            }
        }
        catch (Exception e) {
            AttributeModify.LOGGER.error("Error processing Curios event: {}", (Object)e.getMessage());
        }
    }
}

