/*
 * Decompiled with CFR 0.152.
 */
package com.tizio.tridentenchantmentsoverhaul.mixin;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TridentItem.class})
public abstract class LoyaltyRiptide
extends Item
implements Vanishable {
    public LoyaltyRiptide(Item.Properties settings) {
        super(settings);
    }

    @Inject(at={@At(value="HEAD")}, method={"releaseUsing"}, cancellable=true)
    private void loyalty(ItemStack stack, Level level, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (!level.f_46443_ && EnchantmentHelper.m_44928_((ItemStack)stack) > 0) {
                if (this.m_8105_(stack) - remainingUseTicks >= 10) {
                    stack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(user.m_7655_()));
                    ThrownTrident throwntrident = new ThrownTrident(level, (LivingEntity)player, stack);
                    throwntrident.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f, 1.0f);
                    throwntrident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    level.m_7967_((Entity)throwntrident);
                    level.m_6269_((Player)null, (Entity)throwntrident, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ci.cancel();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"releaseUsing"})
    private void riptide(ItemStack stack, Level level, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (this.m_8105_(stack) - remainingUseTicks >= 10 && player.m_20070_() && EnchantmentHelper.m_44932_((ItemStack)stack) > 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 100, 0));
            }
        }
    }
}

