/*
 * Decompiled with CFR 0.152.
 */
package com.tizio.tridentenchantmentsoverhaul.mixin;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TridentItem.class})
public abstract class LoyaltyRiptide
extends Item
implements ProjectileItem {
    public LoyaltyRiptide(Item.Properties properties) {
        super(properties);
    }

    @Inject(at={@At(value="HEAD")}, method={"releaseUsing"}, cancellable=true)
    private void loyalty(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft, CallbackInfo ci) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (!level.isClientSide && EnchantmentHelper.getEnchantmentLevel((Holder)level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.LOYALTY), (LivingEntity)entityLiving) > 0) {
                if (this.getUseDuration(stack, (LivingEntity)player) - timeLeft >= 10) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)entityLiving.getUsedItemHand()));
                    ThrownTrident throwntrident = new ThrownTrident(level, (LivingEntity)player, stack);
                    throwntrident.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
                    throwntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    level.addFreshEntity((Entity)throwntrident);
                    Holder holder = EnchantmentHelper.pickHighestLevel((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
                    level.playSound((Player)null, (Entity)throwntrident, (SoundEvent)holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                ci.cancel();
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"releaseUsing"})
    private void riptide(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft, CallbackInfo ci) {
        Player player;
        if (entityLiving instanceof Player && this.getUseDuration(stack, (LivingEntity)(player = (Player)entityLiving)) - timeLeft >= 10 && player.isInWaterOrRain() && EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)stack, (LivingEntity)player) > 0.0f) {
            player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 100, 0));
        }
    }
}

