/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entity;

import net.chococraft.ChococraftExpectPlatform;
import net.chococraft.common.entity.DefaultNames;
import net.chococraft.common.entity.breeding.BreedingHelper;
import net.chococraft.common.entity.breeding.ChocoboAbilityInfo;
import net.chococraft.common.entity.goal.ChocoboFollowOwnerGoal;
import net.chococraft.common.entity.goal.ChocoboHealInPenGoal;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.chococraft.common.entity.properties.MovementType;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.chococraft.common.items.armor.AbstractChocoDisguiseItem;
import net.chococraft.registry.ModEntities;
import net.chococraft.registry.ModRegistry;
import net.chococraft.registry.ModSounds;
import net.chococraft.utils.RandomHelper;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7225;
import net.minecraft.class_7248;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChocobo
extends class_1321
implements class_7248 {
    private static final class_2960 STEP_HEIGHT_ID = class_2960.method_60655((String)"chococraft", (String)"step_height");
    private static final String NBTKEY_CHOCOBO_COLOR = "Color";
    private static final String NBTKEY_CHOCOBO_IS_MALE = "Male";
    private static final String NBTKEY_MOVEMENTTYPE = "MovementType";
    protected static final String NBTKEY_SADDLE_ITEM = "Saddle";
    protected static final String NBTKEY_INVENTORY = "Inventory";
    private static final String NBTKEY_CHOCOBO_GENERATION = "Generation";
    private static final String NBTKEY_ALLOWED_FLIGHT = "AllowedFlight";
    private static final class_2940<ChocoboColor> PARAM_COLOR = class_2945.method_12791(AbstractChocobo.class, ChococraftExpectPlatform.getColorSerializer());
    private static final class_2940<Boolean> PARAM_IS_MALE = class_2945.method_12791(AbstractChocobo.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> PARAM_FED_GOLD_GYSAHL = class_2945.method_12791(AbstractChocobo.class, (class_2941)class_2943.field_13323);
    private static final class_2940<MovementType> PARAM_MOVEMENT_TYPE = class_2945.method_12791(AbstractChocobo.class, ChococraftExpectPlatform.getMovementSerializer());
    private static final class_2940<class_1799> PARAM_SADDLE_ITEM = class_2945.method_12791(AbstractChocobo.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> ALLOWED_FLIGHT = class_2945.method_12791(AbstractChocobo.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> PARAM_GENERATION = class_2945.method_12791(AbstractChocobo.class, (class_2941)class_2943.field_13327);
    private class_1338<class_1657> chocoboAvoidPlayerGoal;
    private ChocoboHealInPenGoal healInPenGoal;
    private float wingRotation;
    private float destPos;
    private float wingRotDelta;
    public int timeSinceFeatherChance = 0;
    private final ChocoboFollowOwnerGoal follow = new ChocoboFollowOwnerGoal(this, 2.0, 3.0f, 10.0f);

    public AbstractChocobo(class_1299<? extends AbstractChocobo> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new ChocoboFollowOwnerGoal(this, 1.0, 5.0f, 5.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 5.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23720, 0.0).method_26868(class_5134.field_23716, 30.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PARAM_COLOR, (Object)ChocoboColor.YELLOW);
        builder.method_56912(PARAM_IS_MALE, (Object)false);
        builder.method_56912(PARAM_FED_GOLD_GYSAHL, (Object)false);
        builder.method_56912(PARAM_MOVEMENT_TYPE, (Object)MovementType.WANDER);
        builder.method_56912(PARAM_SADDLE_ITEM, (Object)class_1799.field_8037);
        builder.method_56912(PARAM_GENERATION, (Object)0);
        builder.method_56912(ALLOWED_FLIGHT, (Object)true);
    }

    public class_1315 method_5943(class_5425 levelAccessor, class_1266 difficultyIn, class_3730 reason, @Nullable class_1315 spawnDataIn) {
        if (levelAccessor.method_23753(new class_2338((class_2382)this.method_24515().method_10074())).method_40220(class_6908.field_36518)) {
            this.setChocoboColor(ChocoboColor.FLAME);
        }
        this.finalizeChocobo(this);
        return super.method_5943(levelAccessor, difficultyIn, reason, spawnDataIn);
    }

    private void finalizeChocobo(AbstractChocobo chocobo) {
        chocobo.setMale(this.field_5974.method_43056());
        chocobo.method_5996(class_5134.field_23716).method_6192((double)this.getChocoboColor().getAbilityInfo().getMaxHP());
        chocobo.method_6033(this.method_6063());
        chocobo.method_5996(class_5134.field_23719).method_6192((double)(this.getChocoboColor().getAbilityInfo().getLandSpeed() / 100.0f));
        chocobo.method_5996(class_5134.field_23720).method_6192((double)(this.getChocoboColor().getAbilityInfo().getAirbornSpeed() / 100.0f));
        chocobo.setAllowedFlight(ChococraftExpectPlatform.canChocobosFly());
        this.reassessTameGoals();
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setChocoboColor(ChocoboColor.values()[compound.method_10571(NBTKEY_CHOCOBO_COLOR)]);
        this.setMale(compound.method_10577(NBTKEY_CHOCOBO_IS_MALE));
        this.setMovementType(MovementType.values()[compound.method_10571(NBTKEY_MOVEMENTTYPE)]);
        this.setGeneration(compound.method_10550(NBTKEY_CHOCOBO_GENERATION));
        if (compound.method_10573("wornSaddle", 10)) {
            this.setSaddleType(class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)compound.method_10562("wornSaddle")));
        }
        this.setAllowedFlight(compound.method_10577(NBTKEY_ALLOWED_FLIGHT));
        this.reassessTameGoals();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10567(NBTKEY_CHOCOBO_COLOR, (byte)this.getChocoboColor().ordinal());
        compound.method_10556(NBTKEY_CHOCOBO_IS_MALE, this.isMale());
        compound.method_10567(NBTKEY_MOVEMENTTYPE, (byte)this.getMovementType().ordinal());
        compound.method_10569(NBTKEY_CHOCOBO_GENERATION, this.getGeneration());
        if (!this.getSaddle().method_7960()) {
            compound.method_10566("wornSaddle", this.getSaddle().method_57376((class_7225.class_7874)this.method_56673(), (class_2520)new class_2487()));
        }
        compound.method_10556(NBTKEY_ALLOWED_FLIGHT, this.allowedFlight());
    }

    public ChocoboColor getChocoboColor() {
        return (ChocoboColor)((Object)this.field_6011.method_12789(PARAM_COLOR));
    }

    public void setChocoboColor(ChocoboColor color) {
        this.field_6011.method_12778(PARAM_COLOR, (Object)color);
    }

    public boolean method_5753() {
        return this.getChocoboColor().getAbilityInfo().isImmuneToFire();
    }

    public boolean isMale() {
        return (Boolean)this.field_6011.method_12789(PARAM_IS_MALE);
    }

    public void setMale(boolean isMale) {
        this.field_6011.method_12778(PARAM_IS_MALE, (Object)isMale);
    }

    public boolean isFedGoldGysahl() {
        return (Boolean)this.field_6011.method_12789(PARAM_FED_GOLD_GYSAHL);
    }

    public void setFedGoldGysahl(boolean value) {
        this.field_6011.method_12778(PARAM_FED_GOLD_GYSAHL, (Object)value);
    }

    public MovementType getMovementType() {
        return (MovementType)((Object)this.field_6011.method_12789(PARAM_MOVEMENT_TYPE));
    }

    public void setMovementType(MovementType type) {
        this.field_6011.method_12778(PARAM_MOVEMENT_TYPE, (Object)type);
    }

    public boolean isSaddled() {
        return !this.getSaddle().method_7960();
    }

    public class_1799 getSaddle() {
        return (class_1799)this.field_6011.method_12789(PARAM_SADDLE_ITEM);
    }

    protected void setSaddleType(class_1799 saddleStack) {
        class_1799 oldStack = this.getSaddle();
        if (oldStack.method_7909() != saddleStack.method_7909()) {
            this.field_6011.method_12778(PARAM_SADDLE_ITEM, (Object)saddleStack.method_7972());
            this.reconfigureInventory(oldStack, saddleStack);
        }
    }

    public int getGeneration() {
        return (Integer)this.field_6011.method_12789(PARAM_GENERATION);
    }

    public void setGeneration(int value) {
        this.field_6011.method_12778(PARAM_GENERATION, (Object)value);
    }

    public boolean allowedFlight() {
        return (Boolean)this.field_6011.method_12789(ALLOWED_FLIGHT);
    }

    public void setAllowedFlight(boolean value) {
        this.field_6011.method_12778(ALLOWED_FLIGHT, (Object)value);
    }

    protected class_243 method_52533(class_1297 entity, class_4048 entityDimensions, float f) {
        return new class_243(0.0, (double)1.65f, 0.0);
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 entity = this.method_31483();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            return this.canBeControlledBy(livingEntity) ? livingEntity : null;
        }
        return null;
    }

    private boolean canBeControlledBy(class_1309 entity) {
        return this.method_6181() && this.isSaddled();
    }

    protected boolean method_5876() {
        return super.method_5876();
    }

    public boolean method_26319(class_3610 fluidState) {
        boolean flag = this.method_5642() != null && this.method_5642().field_6282;
        return fluidState.method_15767(class_3486.field_15517) && this.getAbilityInfo().canWalkOnWater() && !flag;
    }

    public void method_6091(class_243 travelVector) {
        if (this.method_5805()) {
            class_1309 livingentity = this.method_5642();
            if (this.method_5782() && livingentity != null) {
                this.method_36456(livingentity.method_36454());
                this.field_5982 = this.method_36454();
                this.method_36457(livingentity.method_36455() * 0.5f);
                this.method_5710(this.method_36454(), this.method_36455());
                this.field_6241 = this.field_6283 = this.method_36454();
                float strafe = livingentity.field_6212 * 0.5f;
                float forward = livingentity.field_6250;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (livingentity.field_6282 && this.getAbilityInfo().getCanFly() && this.allowedFlight()) {
                    this.method_6100(true);
                    this.method_6043();
                    this.field_6007 = true;
                    this.method_5724(this.getChocoboColor().getAbilityInfo().getAirbornSpeed() / 100.0f, travelVector);
                } else if (livingentity.field_6282 && !this.field_6282) {
                    if (this.method_5799()) {
                        if (this.getAbilityInfo().canWalkOnWater()) {
                            if (this.method_5869()) {
                                this.method_6010(class_3486.field_15517);
                            }
                        } else {
                            this.method_18799(this.method_18798().method_1031(0.0, (double)(0.01f + this.field_5974.method_43057() * 0.09f), 0.0));
                        }
                    } else if (this.method_5799() && this.getAbilityInfo().canWalkOnWater()) {
                        this.method_6093();
                    } else if (this.method_24828()) {
                        this.method_6043();
                        livingentity.method_6100(false);
                        this.method_6100(true);
                    }
                }
                if (this.method_5787()) {
                    this.method_6125((float)this.method_45325(class_5134.field_23719));
                    super.method_6091(new class_243((double)strafe, travelVector.field_1351, (double)forward));
                } else if (livingentity instanceof class_1657) {
                    this.method_18799(class_243.field_1353);
                }
                if (this.method_24828()) {
                    this.method_6100(false);
                }
                this.method_29242(false);
                this.method_36974();
            } else {
                super.method_6091(travelVector);
            }
        }
    }

    protected ChocoboAbilityInfo getAbilityInfo() {
        return this.getChocoboColor().getAbilityInfo();
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 moveFunction) {
        super.method_5865(passenger, moveFunction);
        if (passenger instanceof class_1308 && this.method_5642() == passenger) {
            this.field_6283 = ((class_1309)passenger).field_6283;
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 partner) {
        AbstractChocobo babyChocobo = (AbstractChocobo)((class_1299)ModEntities.CHOCOBO.get()).method_5883((class_1937)level);
        babyChocobo.setChocoboColor(BreedingHelper.getColor(this, (AbstractChocobo)partner));
        this.finalizeChocobo(babyChocobo);
        this.setFedGoldGysahl(false);
        ((AbstractChocobo)partner).setFedGoldGysahl(false);
        return babyChocobo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void method_24650(class_3218 level, class_1429 partner) {
        if (partner instanceof AbstractChocobo) {
            AbstractChocobo target = (AbstractChocobo)partner;
            if (this.getChocoboColor() == ChocoboColor.PURPLE && target.getChocoboColor() == ChocoboColor.PURPLE) {
                this.method_5699(new class_1799((class_1935)ModRegistry.PURPLE_CHOCOBO_SPAWN_EGG.get()), 0.0f);
                this.method_5614(6000);
                target.method_5614(6000);
                this.method_6477();
                target.method_6477();
                return;
            }
        }
        super.method_24650(level, partner);
    }

    public boolean method_6474(class_1429 parent) {
        if (parent == this || !(parent instanceof AbstractChocobo)) {
            return false;
        }
        AbstractChocobo otherChocobo = (AbstractChocobo)parent;
        if (!this.method_6479() || !parent.method_6479()) {
            return false;
        }
        return otherChocobo.isMale() != this.isMale();
    }

    public void dropFeather() {
        if (this.method_5770().field_9236) {
            return;
        }
        if (this.method_6109()) {
            return;
        }
        this.method_5699(new class_1799((class_1935)ModRegistry.CHOCOBO_FEATHER.get(), 1), 0.0f);
    }

    protected boolean method_5860(class_1297 entityIn) {
        return !this.getSaddle().method_7960() && super.method_5860(entityIn);
    }

    public void method_6007() {
        super.method_6007();
        this.method_5710(this.method_36454(), this.method_36455());
        this.method_38785();
        if (this.timeSinceFeatherChance == 3000) {
            this.timeSinceFeatherChance = 0;
            if ((double)((float)Math.random()) < 0.25) {
                this.dropFeather();
            }
        } else {
            ++this.timeSinceFeatherChance;
        }
        if (!this.method_37908().field_9236 && this.method_5765() && this.method_5782()) {
            this.method_5848();
        }
        if (this.method_5770().field_9236) {
            this.destPos += (float)((double)(this.method_24828() ? -1 : 4) * 0.3);
            this.destPos = class_3532.method_15363((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.method_24828()) {
                this.wingRotDelta = Math.min(this.wingRotation, 1.0f);
            }
            this.wingRotDelta *= 0.9f;
            this.wingRotation += this.wingRotDelta * 2.0f;
            if (this.method_24828()) {
                this.method_29242(false);
            } else {
                this.field_42108.method_48572(0.0f);
                this.field_42108.method_48567(0.0f);
            }
        }
    }

    public void method_5773() {
        class_1297 class_12972;
        super.method_5773();
        if (this.method_5782() && (class_12972 = this.method_31483()) instanceof class_1309) {
            class_1309 passenger = (class_1309)class_12972;
            this.getAbilityInfo().getRiderAbilities().forEach(ability -> {
                passenger.method_6092((class_1293)ability.get());
                this.method_6092((class_1293)ability.get());
            });
        }
        this.updateStepHeight();
    }

    private void updateStepHeight() {
        class_1324 attributeinstance = this.method_5996(class_5134.field_47761);
        float stepHeight = this.getAbilityInfo().getStepHeight(true);
        if (attributeinstance != null) {
            attributeinstance.method_55696(new class_1322(STEP_HEIGHT_ID, (double)stepHeight, class_1322.class_1323.field_6328));
        }
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574((class_1792)ModRegistry.LOVERLY_GYSAHL_GREEN.get()) || stack.method_31574((class_1792)ModRegistry.GOLD_GYSAHL.get()) || stack.method_31574((class_1792)ModRegistry.GYSAHL_CAKE.get());
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 heldItemStack = player.method_5998(hand);
        if (this.method_6481(heldItemStack)) {
            boolean fedCake;
            boolean bl = fedCake = heldItemStack.method_7909() == ModRegistry.GYSAHL_CAKE.get();
            if (this.method_6109()) {
                if (fedCake) {
                    this.method_6475(player, hand, heldItemStack);
                    this.method_7217(false);
                    return class_1269.method_29236((boolean)this.method_37908().field_9236);
                }
            } else {
                int i = this.method_5618();
                if (!this.method_37908().field_9236 && i == 0 && this.method_6482() && !fedCake) {
                    if (heldItemStack.method_7909() == ModRegistry.GOLD_GYSAHL.get()) {
                        this.setFedGoldGysahl(true);
                    }
                    this.method_6475(player, hand, heldItemStack);
                    this.method_6480(player);
                    return class_1269.field_5812;
                }
            }
            if (this.method_37908().field_9236) {
                return class_1269.field_21466;
            }
        }
        if (this.method_37908().field_9236) {
            return class_1269.field_5811;
        }
        if (this.method_6181()) {
            if (this.isSaddled() && !this.method_5782() && player.method_6047().method_7960() && !player.method_5715() && !this.method_6109()) {
                player.method_5804((class_1297)this);
                return class_1269.field_5812;
            }
            if (player.method_5715() && !this.method_6109() && player.method_6047().method_7960()) {
                this.method_6722((class_1657)((class_3222)player));
                return class_1269.field_5812;
            }
            if (heldItemStack.method_31574((class_1792)ModRegistry.CHOCOBO_WHISTLE.get()) && !this.method_6109()) {
                if (this.method_6171((class_1309)player)) {
                    if (this.getMovementType() == MovementType.STANDSTILL) {
                        this.method_5783((class_3414)ModSounds.WHISTLE_SOUND_FOLLOW.get(), 1.0f, 1.0f);
                        this.method_5977(false);
                        this.field_6201.method_6277(0, (class_1352)this.follow);
                        this.setMovementType(MovementType.FOLLOW_OWNER);
                        player.method_7353((class_2561)class_2561.method_43471((String)"chococraft.entity_chocobo.chocobo_followcmd"), true);
                    } else if (this.getMovementType() == MovementType.FOLLOW_OWNER) {
                        this.method_5783((class_3414)ModSounds.WHISTLE_SOUND_WANDER.get(), 1.0f, 1.0f);
                        this.field_6201.method_6280((class_1352)this.follow);
                        this.setMovementType(MovementType.WANDER);
                        player.method_7353((class_2561)class_2561.method_43471((String)"chococraft.entity_chocobo.chocobo_wandercmd"), true);
                    } else if (this.getMovementType() == MovementType.WANDER) {
                        this.method_5783((class_3414)ModSounds.WHISTLE_SOUND_STAY.get(), 1.0f, 1.0f);
                        this.method_5977(true);
                        this.setMovementType(MovementType.STANDSTILL);
                        player.method_7353((class_2561)class_2561.method_43471((String)"chococraft.entity_chocobo.chocobo_staycmd"), true);
                    }
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"chococraft.entity_chocobo.not_owner"), true);
                }
                return class_1269.field_5812;
            }
            if (heldItemStack.method_31574((class_1792)ModRegistry.GYSAHL_GREEN_ITEM.get())) {
                if (this.method_6032() != this.method_6063()) {
                    this.method_6475(player, hand, heldItemStack);
                    this.method_6025(5.0f);
                    this.method_32875((class_6880)class_5712.field_28735, (class_1297)this);
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"chococraft.entity_chocobo.heal_fail"), true);
                return class_1269.field_5811;
            }
            if (this.getChocoboColor() == ChocoboColor.GOLD) {
                if (heldItemStack.method_7909() == ModRegistry.RED_GYSAHL.get()) {
                    this.method_6475(player, hand, heldItemStack);
                    this.setChocoboColor(ChocoboColor.RED);
                    return class_1269.field_5812;
                }
                if (heldItemStack.method_7909() == ModRegistry.PINK_GYSAHL.get()) {
                    this.method_6475(player, hand, heldItemStack);
                    this.setChocoboColor(ChocoboColor.PINK);
                    return class_1269.field_5812;
                }
            }
            if (heldItemStack.method_7909() instanceof ChocoboSaddleItem && !this.isSaddled() && !this.method_6109()) {
                this.setSaddled(player, hand, new class_1799((class_1935)heldItemStack.method_7909()));
                if (!player.method_31549().field_7477) {
                    heldItemStack.method_7934(1);
                }
                return class_1269.field_5812;
            }
        } else if (heldItemStack.method_31574((class_1792)ModRegistry.GYSAHL_GREEN_ITEM.get())) {
            this.method_6475(player, hand, heldItemStack);
            if ((float)Math.random() < ChococraftExpectPlatform.getTameChance()) {
                this.method_6174(player.method_5667());
                this.method_6173(true, false);
                if (ChococraftExpectPlatform.nameTamedChocobos() && !this.method_16914()) {
                    this.method_5665((class_2561)DefaultNames.getRandomName(this.field_5974, this.isMale()));
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"chococraft.entity_chocobo.tame_success"), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"chococraft.entity_chocobo.tame_fail"), true);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected abstract void setSaddled(class_1657 var1, class_1268 var2, class_1799 var3);

    protected abstract void reconfigureInventory(class_1799 var1, class_1799 var2);

    protected void method_16077(class_1282 damageSourceIn, boolean attackedRecently) {
        super.method_16077(damageSourceIn, attackedRecently);
        this.dropInventory();
    }

    protected abstract void dropInventory();

    protected class_3414 method_5994() {
        return (class_3414)ModSounds.AMBIENT_SOUND.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModSounds.AMBIENT_SOUND.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModSounds.AMBIENT_SOUND.get();
    }

    protected float method_6107() {
        return 0.6f;
    }

    public int method_5970() {
        return 24 * (int)(Math.random() * (double)ChococraftExpectPlatform.kwehIntervalLimit());
    }

    public float method_6144(class_2338 pos, class_4538 levelReader) {
        if (this.method_37908().method_23753(new class_2338((class_2382)this.method_24515())).method_40220(class_6908.field_36518)) {
            return 0.0f;
        }
        return super.method_6144(pos, levelReader);
    }

    public void method_6173(boolean tame, boolean applyTamingSideEffects) {
        super.method_6173(tame, applyTamingSideEffects);
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
        if (this.chocoboAvoidPlayerGoal == null) {
            this.chocoboAvoidPlayerGoal = new class_1338((class_1314)this, class_1657.class, 10.0f, 1.0, 1.2, livingEntity -> {
                if (livingEntity instanceof class_1657) {
                    class_1657 player = (class_1657)livingEntity;
                    int chance = 0;
                    for (class_1799 stack : player.method_5661()) {
                        if (stack == null || stack.method_7960() || !(stack.method_7909() instanceof AbstractChocoDisguiseItem)) continue;
                        chance += 25;
                    }
                    return !RandomHelper.getChanceResult(this.method_59922(), chance);
                }
                return false;
            });
        }
        if (this.healInPenGoal == null) {
            this.healInPenGoal = new ChocoboHealInPenGoal(this);
        }
        this.field_6201.method_6280(this.chocoboAvoidPlayerGoal);
        this.field_6201.method_6280((class_1352)this.healInPenGoal);
        if (this.method_6181()) {
            this.field_6201.method_6277(4, (class_1352)this.healInPenGoal);
        } else {
            this.field_6201.method_6277(5, this.chocoboAvoidPlayerGoal);
        }
    }

    public static boolean checkChocoboSpawnRules(class_1299<? extends AbstractChocobo> entityType, class_1936 levelAccessor, class_3730 spawnType, class_2338 pos, class_5819 randomSource) {
        if (levelAccessor.method_23753(new class_2338((class_2382)pos)).method_40220(class_6908.field_36518)) {
            class_2338 blockpos = pos.method_10074();
            return spawnType == class_3730.field_16469 || levelAccessor.method_8320(blockpos).method_26170((class_1922)levelAccessor, blockpos, entityType);
        }
        return levelAccessor.method_8320(pos.method_10074()).method_26164(class_3481.field_35567) && AbstractChocobo.method_39448((class_1920)levelAccessor, (class_2338)pos);
    }
}

