/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.fabric.datagen.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.chococraft.Chococraft;
import net.chococraft.fabric.datagen.client.SoundDefinition;
import net.chococraft.registry.ModSounds;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChocoSoundProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, SoundDefinition> sounds = new LinkedHashMap<String, SoundDefinition>();
    protected final FabricDataOutput dataOutput;

    public ChocoSoundProvider(FabricDataOutput dataOutput) {
        this.dataOutput = dataOutput;
    }

    public void registerSounds() {
        this.add((Supplier<class_3414>)ModSounds.AMBIENT_SOUND, ChocoSoundProvider.definition().subtitle(this.modSubtitle(ModSounds.AMBIENT_SOUND.getId())).with(ChocoSoundProvider.sound(this.modLoc("entity/chocobo/kweh"))));
        this.add((Supplier<class_3414>)ModSounds.WHISTLE_SOUND_FOLLOW, ChocoSoundProvider.definition().subtitle(this.modSubtitle(ModSounds.WHISTLE_SOUND_FOLLOW.getId())).with(ChocoSoundProvider.sound(this.modLoc("entity/chocobo/kwehwhistlefollow"))));
        this.add((Supplier<class_3414>)ModSounds.WHISTLE_SOUND_STAY, ChocoSoundProvider.definition().subtitle(this.modSubtitle(ModSounds.WHISTLE_SOUND_STAY.getId())).with(ChocoSoundProvider.sound(this.modLoc("entity/chocobo/kwehwhistlestay"))));
        this.add((Supplier<class_3414>)ModSounds.WHISTLE_SOUND_WANDER, ChocoSoundProvider.definition().subtitle(this.modSubtitle(ModSounds.WHISTLE_SOUND_WANDER.getId())).with(ChocoSoundProvider.sound(this.modLoc("entity/chocobo/kwehwhistlewander"))));
    }

    public class_2960 modLoc(String path) {
        return Chococraft.modLoc(path);
    }

    public String modSubtitle(class_2960 id) {
        return "chococraft.subtitle." + id.method_12832();
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.sounds.clear();
        this.registerSounds();
        if (!this.sounds.isEmpty()) {
            return this.save(cache, this.dataOutput.method_45972(class_7784.class_7490.field_39368).resolve(this.dataOutput.getModId()).resolve("sounds.json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String method_10321() {
        return "Sound Definitions";
    }

    protected static SoundDefinition definition() {
        return SoundDefinition.definition();
    }

    protected static SoundDefinition.Sound sound(class_2960 name, SoundDefinition.SoundType type) {
        return SoundDefinition.Sound.sound(name, type);
    }

    protected static SoundDefinition.Sound sound(class_2960 name) {
        return ChocoSoundProvider.sound(name, SoundDefinition.SoundType.SOUND);
    }

    protected void add(Supplier<class_3414> soundEvent, SoundDefinition definition) {
        this.add(soundEvent.get(), definition);
    }

    protected void add(class_3414 soundEvent, SoundDefinition definition) {
        this.add(soundEvent.comp_3319(), definition);
    }

    protected void add(class_2960 soundEvent, SoundDefinition definition) {
        this.addSounds(soundEvent.method_12832(), definition);
    }

    protected void add(String soundEvent, SoundDefinition definition) {
        this.add(class_2960.method_12829((String)soundEvent), definition);
    }

    private void addSounds(String soundEvent, SoundDefinition definition) {
        if (this.sounds.put(soundEvent, definition) != null) {
            throw new IllegalStateException("Sound event '" + this.dataOutput.getModId() + ":" + soundEvent + "' already exists");
        }
    }

    private CompletableFuture<?> save(class_7403 cache, Path targetFile) {
        return class_2405.method_10320((class_7403)cache, (JsonElement)this.mapToJson(this.sounds), (Path)targetFile);
    }

    private JsonObject mapToJson(Map<String, SoundDefinition> map) {
        JsonObject obj = new JsonObject();
        map.forEach((k, v) -> obj.add(k, (JsonElement)v.serialize()));
        return obj;
    }
}

