/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.gui;

import java.util.Objects;
import net.chococraft.Chococraft;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ChocoboBookScreen
extends Screen {
    private static final ResourceLocation TEXTURE = Chococraft.modLoc("textures/gui/chocobo_book.png");
    private final Component bookTitle = Component.literal((String)"The Chocopedia").withStyle(ChatFormatting.GOLD);
    private final Component bookAuthor = Component.literal((String)"by Clienthax");
    private final int xSize = 192;
    private final int ySize = 192;
    private int currentPage = 0;
    private final int pageCount;
    private int guiLeft;
    private int guiTop;
    private Component pageMsg = CommonComponents.EMPTY;

    public ChocoboBookScreen() {
        super((Component)Component.empty());
        int maxPages = 1;
        for (int i = 1; i < 128; ++i) {
            String unlocalized = "gui.chocobook.page" + i;
            if (!I18n.get((String)unlocalized, (Object[])new Object[0]).equals(unlocalized)) continue;
            maxPages = i - 1;
            break;
        }
        this.pageCount = maxPages;
    }

    public static void openScreen() {
        Minecraft.getInstance().setScreen((Screen)new ChocoboBookScreen());
    }

    public void init() {
        Objects.requireNonNull(this);
        this.guiLeft = (this.width - 192) / 2;
        Objects.requireNonNull(this);
        this.guiTop = (this.height - 192) / 2;
        this.addRenderableWidget((GuiEventListener)new PageButton(this.guiLeft + 192 - 66, this.guiTop + 158, true, p_98297_ -> {
            this.currentPage = this.currentPage >= this.pageCount ? 0 : this.currentPage + 1;
        }, true));
        this.addRenderableWidget((GuiEventListener)new PageButton(this.guiLeft + 36, this.guiTop + 158, false, p_98287_ -> {
            this.currentPage = this.currentPage <= 0 ? this.pageCount : this.currentPage - 1;
        }, true));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.currentPage == 0) {
            Objects.requireNonNull(this);
            guiGraphics.drawString(this.font, this.bookTitle, this.guiLeft + 192 / 2 - this.font.width((FormattedText)this.bookTitle) / 2, this.guiTop + 24, 0, false);
            Objects.requireNonNull(this);
            guiGraphics.drawString(this.font, this.bookAuthor, this.guiLeft + 192 / 2 - this.font.width((FormattedText)this.bookAuthor) / 2, this.guiTop + 44, 0, false);
        } else {
            if (this.currentPage > 1) {
                this.pageMsg = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage - 1, Math.max(this.pageCount - 1, 1)});
                Objects.requireNonNull(this);
                guiGraphics.drawString(this.font, this.pageMsg, this.guiLeft + (192 / 2 - this.font.width((FormattedText)this.bookAuthor) / 2 - 6), this.guiTop + 14, 0, false);
            }
            this.renderPage(guiGraphics);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderType::guiTextured, TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, 192, 192, 256, 256);
    }

    private void renderPage(GuiGraphics guiGraphics) {
        Objects.requireNonNull(this);
        int i = (this.width - 192) / 2;
        guiGraphics.drawWordWrap(this.font, (FormattedText)Component.translatable((String)("gui.chocobook.page" + this.currentPage)), i + 34, this.guiTop + 26, 120, 0, false);
    }
}

