/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.gui;

import net.chococraft.Chococraft;
import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.inventory.SaddleBagMenu;
import net.chococraft.platform.Services;
import net.chococraft.registry.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChocoboInventoryScreen
extends AbstractContainerScreen<SaddleBagMenu> {
    private static final ResourceLocation INV_TEXTURE_NULL = Chococraft.modLoc("textures/gui/chocobo_inventory_null.png");
    private static final ResourceLocation INV_TEXTURE_SMALL = Chococraft.modLoc("textures/gui/chocobo_inventory_small.png");
    private static final ResourceLocation INV_TEXTURE_LARGE = Chococraft.modLoc("textures/gui/chocobo_inventory_large.png");

    public ChocoboInventoryScreen(SaddleBagMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 204;
    }

    public static void openInventory(int windowId, AbstractChocobo chocobo) {
        LocalPlayer player = Minecraft.getInstance().player;
        SaddleBagMenu saddleContainer = Services.PLATFORM.constructMenu(windowId, player.getInventory(), chocobo);
        player.containerMenu = saddleContainer;
        Minecraft.getInstance().setScreen((Screen)new ChocoboInventoryScreen(saddleContainer, player.getInventory(), chocobo.getDisplayName()));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        ResourceLocation texture = INV_TEXTURE_NULL;
        ItemStack saddleStack = ((SaddleBagMenu)this.menu).getSlot(0).getItem();
        if (!saddleStack.isEmpty()) {
            Item item = saddleStack.getItem();
            if (item == ModRegistry.CHOCOBO_SADDLE.get()) {
                texture = INV_TEXTURE_NULL;
            } else if (item == ModRegistry.CHOCOBO_SADDLE_BAGS.get()) {
                texture = INV_TEXTURE_SMALL;
            } else if (item == ModRegistry.CHOCOBO_SADDLE_PACK.get()) {
                texture = INV_TEXTURE_LARGE;
            }
        } else {
            texture = INV_TEXTURE_NULL;
        }
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderType::guiTextured, texture, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        guiGraphics.blit(RenderType::guiTextured, texture, i - 24, j + 10, 0.0f, 204.0f, 27, 33, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0x888888, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x888888, false);
    }
}

