/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.models.entities;

import net.chococraft.client.renderer.states.ChocoboRenderState;
import net.chococraft.common.entity.AbstractChocobo;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class AdultChocoboModel<T extends AbstractChocobo>
extends EntityModel<ChocoboRenderState> {
    private final ModelPart root;
    private final ModelPart wing_left;
    private final ModelPart wing_right;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart leg_left;
    private final ModelPart leg_right;

    public AdultChocoboModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        ModelPart body = this.root.getChild("body");
        this.neck = body.getChild("chest").getChild("neck");
        this.head = this.neck.getChild("head");
        this.leg_left = body.getChild("leg_left");
        this.leg_right = body.getChild("leg_right");
        this.wing_left = body.getChild("wing_left");
        this.wing_right = body.getChild("wing_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)-4.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-22.0f, (float)1.0f));
        PartDefinition saddlebag_right_r1 = body.addOrReplaceChild("saddlebag_right_r1", CubeListBuilder.create().texOffs(81, 6).mirror().addBox(-7.5f, -5.0f, -3.0f, 2.0f, 8.0f, 6.0f, new CubeDeformation(-0.1f)).mirror(false).texOffs(81, 6).addBox(5.5f, -5.0f, -3.0f, 2.0f, 8.0f, 6.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)6.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition storage_back_r1 = body.addOrReplaceChild("storage_back_r1", CubeListBuilder.create().texOffs(36, 2).addBox(-5.0f, -6.0f, -3.0f, 10.0f, 6.0f, 12.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition fan_bottom_r1 = body.addOrReplaceChild("fan_bottom_r1", CubeListBuilder.create().texOffs(101, 29).addBox(-3.5f, -4.5f, 0.0f, 7.0f, 6.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)9.0f, (float)-0.9163f, (float)0.0f, (float)0.0f));
        PartDefinition fan_top_r1 = body.addOrReplaceChild("fan_top_r1", CubeListBuilder.create().texOffs(55, 25).addBox(-5.5f, -10.0f, -2.0f, 11.0f, 10.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)10.0f, (float)-0.5672f, (float)0.0f, (float)0.0f));
        PartDefinition fan_right_r1 = body.addOrReplaceChild("fan_right_r1", CubeListBuilder.create().texOffs(45, 28).addBox(-1.0f, -11.0f, -1.0f, 0.0f, 14.0f, 9.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)9.0f, (float)-0.1309f, (float)-0.7418f, (float)-0.1309f));
        PartDefinition fan_left_r1 = body.addOrReplaceChild("fan_left_r1", CubeListBuilder.create().texOffs(45, 28).addBox(1.0f, -11.0f, -1.0f, 0.0f, 14.0f, 9.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)9.0f, (float)-0.1309f, (float)0.7418f, (float)0.1309f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 36).addBox(-6.0f, -7.0f, -8.0f, 12.0f, 11.0f, 16.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition wing_left = body.addOrReplaceChild("wing_left", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)-5.0f, (float)-3.0f));
        PartDefinition wing_right_r1 = wing_left.addOrReplaceChild("wing_right_r1", CubeListBuilder.create().texOffs(83, 21).addBox(0.0f, -2.0f, -3.0f, 1.0f, 10.0f, 16.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)0.0436f, (float)-0.0873f));
        PartDefinition wing_right = body.addOrReplaceChild("wing_right", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-5.0f, (float)-3.0f));
        PartDefinition wing_right_r2 = wing_right.addOrReplaceChild("wing_right_r2", CubeListBuilder.create().texOffs(83, 21).addBox(0.0f, -2.0f, -3.0f, 1.0f, 10.0f, 16.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)-0.0436f, (float)0.0873f));
        PartDefinition chest = body.addOrReplaceChild("chest", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)-6.0f));
        PartDefinition chest_r1 = chest.addOrReplaceChild("chest_r1", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, -4.0f, -5.0f, 8.0f, 8.0f, 10.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition neck = chest.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.0f, (float)-2.0f));
        PartDefinition neck_r1 = neck.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(36, 20).addBox(-2.0f, -12.0f, -3.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -5.0f, -9.0f, 6.0f, 6.0f, 12.0f), PartPose.offset((float)0.0f, (float)-11.0f, (float)-2.0f));
        PartDefinition crest_top_r1 = head.addOrReplaceChild("crest_top_r1", CubeListBuilder.create().texOffs(20, 0).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 0.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)3.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition crest_right_r1 = head.addOrReplaceChild("crest_right_r1", CubeListBuilder.create().texOffs(2, 2).mirror().addBox(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition crest_left_r1 = head.addOrReplaceChild("crest_left_r1", CubeListBuilder.create().texOffs(2, 2).addBox(0.0f, -5.0f, 0.0f, 0.0f, 6.0f, 4.0f), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)3.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition leg_left = body.addOrReplaceChild("leg_left", CubeListBuilder.create(), PartPose.offset((float)3.5f, (float)3.0f, (float)1.0f));
        PartDefinition leg_left_lower_r1 = leg_left.addOrReplaceChild("leg_left_lower_r1", CubeListBuilder.create().texOffs(79, 48).addBox(-1.5f, -2.0f, 1.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leg_left_upper_r1 = leg_left.addOrReplaceChild("leg_left_upper_r1", CubeListBuilder.create().texOffs(60, 49).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 9.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition foot_left = leg_left.addOrReplaceChild("foot_left", CubeListBuilder.create().texOffs(104, 53).addBox(-1.0f, -2.0f, 1.5f, 2.0f, 2.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)-2.0f, (float)0.0f, (float)-0.2182f, (float)0.0f));
        PartDefinition toe_right_r1 = foot_left.addOrReplaceChild("toe_right_r1", CubeListBuilder.create().texOffs(92, 54).addBox(-2.0f, -3.0f, -5.0f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.2618f, (float)0.0f));
        PartDefinition toe_left_r1 = foot_left.addOrReplaceChild("toe_left_r1", CubeListBuilder.create().texOffs(92, 54).addBox(0.0f, -3.0f, -5.0f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)-0.2618f, (float)0.0f));
        PartDefinition leg_right = body.addOrReplaceChild("leg_right", CubeListBuilder.create(), PartPose.offset((float)-3.5f, (float)3.0f, (float)1.0f));
        PartDefinition leg_right_lower_r1 = leg_right.addOrReplaceChild("leg_right_lower_r1", CubeListBuilder.create().texOffs(79, 48).addBox(-1.5f, -2.0f, 1.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right_upper_r1 = leg_right.addOrReplaceChild("leg_right_upper_r1", CubeListBuilder.create().texOffs(60, 49).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 9.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition foot_right = leg_right.addOrReplaceChild("foot_right", CubeListBuilder.create().texOffs(104, 53).addBox(-1.0f, -2.0f, 1.5f, 2.0f, 2.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)-2.0f, (float)0.0f, (float)0.2182f, (float)0.0f));
        PartDefinition toe_right_r2 = foot_right.addOrReplaceChild("toe_right_r2", CubeListBuilder.create().texOffs(92, 54).addBox(-2.0f, -3.0f, -5.0f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.2618f, (float)0.0f));
        PartDefinition toe_left_r2 = foot_right.addOrReplaceChild("toe_left_r2", CubeListBuilder.create().texOffs(92, 54).addBox(0.0f, -3.0f, -5.0f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)-0.2618f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    private void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }

    public void setupAnim(ChocoboRenderState renderState) {
        super.setupAnim((EntityRenderState)renderState);
        float headPitch = renderState.xRot;
        float netHeadYaw = renderState.yRot;
        float limbSwingAmount = renderState.walkAnimationSpeed;
        float limbSwing = renderState.walkAnimationPos;
        float pi = (float)Math.PI;
        this.head.xRot = headPitch * (pi / 180.0f);
        this.head.yRot = netHeadYaw * (pi / 180.0f);
        this.setRightLegXRotation(Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount);
        this.setLeftLegXRotation(Mth.cos((float)(limbSwing * 0.6662f + pi)) * 0.8f * limbSwingAmount);
        Vec3 motion = renderState.deltaMovement;
        if (Math.abs(motion.y) > (double)0.1f || !renderState.onGround) {
            this.setRotateAngle(this.wing_right, pi / 2.0f - pi / 12.0f, -0.0174533f, -90.0f + Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
            this.setRotateAngle(this.wing_left, pi / 2.0f - pi / 12.0f, 0.0174533f, 90.0f + Mth.cos((float)(limbSwing * 0.6662f + pi)) * 1.4f * limbSwingAmount);
            this.setLeftLegXRotation(0.6f);
            this.setRightLegXRotation(0.6f);
        } else {
            this.setRotateAngle(this.wing_right, 0.0f, -0.0174533f, 0.0f);
            this.setRotateAngle(this.wing_left, 0.0f, 0.0174533f, 0.0f);
        }
    }

    private void setLeftLegXRotation(float deltaX) {
        this.leg_left.xRot = 0.2094395f + deltaX;
    }

    private void setRightLegXRotation(float deltaX) {
        this.leg_right.xRot = 0.2094395f + deltaX;
    }
}

