/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.models.entities;

import net.chococraft.client.renderer.states.ChocoboRenderState;
import net.chococraft.common.entity.AbstractChocobo;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;

public class ChicoboModel<T extends AbstractChocobo>
extends EntityModel<ChocoboRenderState> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leg_left;
    private final ModelPart leg_right;

    public ChicoboModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.head = this.root.getChild("head");
        this.leg_left = this.root.getChild("leg_left");
        this.leg_right = this.root.getChild("leg_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition fan_bottom_r1 = root.addOrReplaceChild("fan_bottom_r1", CubeListBuilder.create().texOffs(16, 26).addBox(-1.5f, -2.5f, 2.0f, 3.0f, 3.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)4.0f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition fan_top_r1 = root.addOrReplaceChild("fan_top_r1", CubeListBuilder.create().texOffs(5, 25).addBox(-2.5f, -4.5f, 0.0f, 5.0f, 4.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)4.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = root.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(30, 14).addBox(-4.0f, -7.5f, -4.0f, 8.0f, 9.0f, 9.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition leg_left = root.addOrReplaceChild("leg_left", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition toe_right_r1 = leg_left.addOrReplaceChild("toe_right_r1", CubeListBuilder.create().texOffs(1, 17).addBox(-1.0f, -1.5f, -2.75f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.1309f, (float)0.2182f, (float)0.0f));
        PartDefinition toe_left_r1 = leg_left.addOrReplaceChild("toe_left_r1", CubeListBuilder.create().texOffs(1, 17).addBox(0.0f, -1.5f, -3.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.1309f, (float)-0.2182f, (float)0.0f));
        PartDefinition toe_back_r1 = leg_left.addOrReplaceChild("toe_back_r1", CubeListBuilder.create().texOffs(0, 10).addBox(-0.5f, -1.0f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition leg_r1 = leg_left.addOrReplaceChild("leg_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = root.addOrReplaceChild("leg_right", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition toe_right_r2 = leg_right.addOrReplaceChild("toe_right_r2", CubeListBuilder.create().texOffs(1, 17).addBox(-1.0f, -1.5f, -3.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.1309f, (float)0.2182f, (float)0.0f));
        PartDefinition toe_left_r2 = leg_right.addOrReplaceChild("toe_left_r2", CubeListBuilder.create().texOffs(1, 17).addBox(0.0f, -1.5f, -3.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.1309f, (float)-0.2182f, (float)0.0f));
        PartDefinition toe_back_r2 = leg_right.addOrReplaceChild("toe_back_r2", CubeListBuilder.create().texOffs(0, 10).addBox(-0.5f, -1.0f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)1.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition leg_r2 = leg_right.addOrReplaceChild("leg_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(42, 0).addBox(-2.5f, -4.5f, -5.5f, 5.0f, 6.0f, 6.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition crest_r1 = head.addOrReplaceChild("crest_r1", CubeListBuilder.create().texOffs(16, 26).addBox(-1.5f, -4.0f, 1.0f, 3.0f, 3.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-1.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition beak_r1 = head.addOrReplaceChild("beak_r1", CubeListBuilder.create().texOffs(22, 5).addBox(-2.5f, -3.0f, -2.0f, 5.0f, 4.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(ChocoboRenderState renderState) {
        super.setupAnim((EntityRenderState)renderState);
        float headPitch = renderState.xRot;
        float netHeadYaw = renderState.yRot;
        float limbSwingAmount = renderState.walkAnimationSpeed;
        float limbSwing = renderState.walkAnimationPos;
        this.head.xRot = -(headPitch / 57.29578f);
        this.head.yRot = netHeadYaw / 57.29578f;
        this.leg_right.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg_left.yRot = Mth.cos((float)(limbSwing * 0.6662f + 3.141593f)) * 1.4f * limbSwingAmount;
    }
}

