/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.renderer.entities;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.chococraft.Chococraft;
import net.chococraft.ChococraftClient;
import net.chococraft.client.models.entities.AdultChocoboModel;
import net.chococraft.client.models.entities.ChicoboModel;
import net.chococraft.client.renderer.layers.LayerCollar;
import net.chococraft.client.renderer.layers.LayerPlumage;
import net.chococraft.client.renderer.layers.LayerSaddle;
import net.chococraft.client.renderer.states.ChocoboRenderState;
import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ChocoboRenderer
extends MobRenderer<AbstractChocobo, ChocoboRenderState, EntityModel<ChocoboRenderState>> {
    private static final Map<ChocoboColor, ResourceLocation> CHOCOBO_PER_COLOR = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(ChocoboColor.YELLOW, Chococraft.modLoc("textures/entities/chocobos/yellowchocobo.png"));
        map.put(ChocoboColor.GREEN, Chococraft.modLoc("textures/entities/chocobos/greenchocobo.png"));
        map.put(ChocoboColor.BLUE, Chococraft.modLoc("textures/entities/chocobos/bluechocobo.png"));
        map.put(ChocoboColor.WHITE, Chococraft.modLoc("textures/entities/chocobos/whitechocobo.png"));
        map.put(ChocoboColor.BLACK, Chococraft.modLoc("textures/entities/chocobos/blackchocobo.png"));
        map.put(ChocoboColor.GOLD, Chococraft.modLoc("textures/entities/chocobos/goldchocobo.png"));
        map.put(ChocoboColor.PINK, Chococraft.modLoc("textures/entities/chocobos/pinkchocobo.png"));
        map.put(ChocoboColor.RED, Chococraft.modLoc("textures/entities/chocobos/redchocobo.png"));
        map.put(ChocoboColor.PURPLE, Chococraft.modLoc("textures/entities/chocobos/purplechocobo.png"));
        map.put(ChocoboColor.FLAME, Chococraft.modLoc("textures/entities/chocobos/flamechocobo.png"));
    });
    private static final Map<ChocoboColor, ResourceLocation> CHICOBO_PER_COLOR = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put(ChocoboColor.YELLOW, Chococraft.modLoc("textures/entities/chicobos/yellowchocobo.png"));
        map.put(ChocoboColor.GREEN, Chococraft.modLoc("textures/entities/chicobos/greenchocobo.png"));
        map.put(ChocoboColor.BLUE, Chococraft.modLoc("textures/entities/chicobos/bluechocobo.png"));
        map.put(ChocoboColor.WHITE, Chococraft.modLoc("textures/entities/chicobos/whitechocobo.png"));
        map.put(ChocoboColor.BLACK, Chococraft.modLoc("textures/entities/chicobos/blackchocobo.png"));
        map.put(ChocoboColor.GOLD, Chococraft.modLoc("textures/entities/chicobos/goldchocobo.png"));
        map.put(ChocoboColor.PINK, Chococraft.modLoc("textures/entities/chicobos/pinkchocobo.png"));
        map.put(ChocoboColor.RED, Chococraft.modLoc("textures/entities/chicobos/redchocobo.png"));
        map.put(ChocoboColor.PURPLE, Chococraft.modLoc("textures/entities/chicobos/purplechocobo.png"));
        map.put(ChocoboColor.FLAME, Chococraft.modLoc("textures/entities/chicobos/flamechocobo.png"));
    });
    private final EntityModel<ChocoboRenderState> chicoboModel;
    private final EntityModel<ChocoboRenderState> chocoboModel = this.getModel();

    public ChocoboRenderer(EntityRendererProvider.Context context) {
        super(context, new AdultChocoboModel(context.bakeLayer(ChococraftClient.CHOCOBO)), 1.0f);
        this.chicoboModel = new ChicoboModel(context.bakeLayer(ChococraftClient.CHICOBO));
        this.addLayer(new LayerCollar((RenderLayerParent<ChocoboRenderState, EntityModel<ChocoboRenderState>>)this));
        this.addLayer(new LayerPlumage((RenderLayerParent<ChocoboRenderState, EntityModel<ChocoboRenderState>>)this));
        this.addLayer(new LayerSaddle((RenderLayerParent<ChocoboRenderState, EntityModel<ChocoboRenderState>>)this));
    }

    public void render(ChocoboRenderState renderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        this.model = renderState.isBaby ? this.chicoboModel : this.chocoboModel;
        super.render((LivingEntityRenderState)renderState, poseStack, multiBufferSource, i);
    }

    public ChocoboRenderState createRenderState() {
        return new ChocoboRenderState();
    }

    public void extractRenderState(AbstractChocobo chocobo, ChocoboRenderState renderState, float f) {
        super.extractRenderState((LivingEntity)chocobo, (LivingEntityRenderState)renderState, f);
        renderState.color = chocobo.getChocoboColor();
        renderState.isBaby = chocobo.isBaby();
        renderState.onGround = chocobo.onGround();
        renderState.isTame = chocobo.isTame();
        renderState.isMale = chocobo.isMale();
        renderState.isSaddled = chocobo.isSaddled();
        renderState.saddle = chocobo.getSaddle();
        renderState.deltaMovement = chocobo.getDeltaMovement();
    }

    public ResourceLocation getTextureLocation(ChocoboRenderState renderState) {
        ChocoboColor color = renderState.color;
        return renderState.isBaby ? CHICOBO_PER_COLOR.get((Object)color) : CHOCOBO_PER_COLOR.get((Object)color);
    }
}

