/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.neoforge.datagen;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.chococraft.neoforge.datagen.client.ChocoLanguage;
import net.chococraft.neoforge.datagen.client.ChocoModels;
import net.chococraft.neoforge.datagen.client.ChocoSoundProvider;
import net.chococraft.neoforge.datagen.data.ChocoBlockTags;
import net.chococraft.neoforge.datagen.data.ChocoDatapack;
import net.chococraft.neoforge.datagen.data.ChocoItemTags;
import net.chococraft.neoforge.datagen.data.ChocoLoot;
import net.chococraft.neoforge.datagen.data.ChocoRecipes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ModDatagenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new ChocoLoot(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new ChocoRecipes.Runner(packOutput, lookupProvider));
        ChocoBlockTags blockTags = new ChocoBlockTags(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blockTags);
        generator.addProvider(true, (DataProvider)new ChocoItemTags(packOutput, lookupProvider, (TagsProvider<Block>)blockTags));
        generator.addProvider(true, (DataProvider)new ChocoDatapack(packOutput, lookupProvider, Set.of("chococraft")));
        generator.addProvider(true, (DataProvider)new ChocoLanguage(packOutput));
        generator.addProvider(true, (DataProvider)new ChocoModels(packOutput));
        generator.addProvider(true, (DataProvider)new ChocoSoundProvider(packOutput));
    }
}

