/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.chococraft.Chococraft;
import net.chococraft.common.blocks.GysahlGreenBlock;
import net.chococraft.common.blocks.StrawBlock;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.chococraft.common.items.ChocoboSpawnEggItem;
import net.chococraft.common.items.ChocopediaItem;
import net.chococraft.common.items.CustomBlockNamedItem;
import net.chococraft.common.items.armor.ModArmorMaterial;
import net.chococraft.platform.Services;
import net.chococraft.registry.ModFoods;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class ModRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"chococraft", (ResourceKey)Registries.BLOCK);
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"chococraft", (ResourceKey)Registries.ITEM);
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((String)"chococraft", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    public static final RegistrySupplier<Block> GYSAHL_GREEN = ModRegistry.registerBlock("gysahl_green", properties -> new GysahlGreenBlock(properties.mapColor(MapColor.GRASS).noCollission().randomTicks().instabreak().sound(SoundType.CROP)), ModRegistry.blockBuilder());
    public static final RegistrySupplier<Block> STRAW = ModRegistry.registerBlock("straw", properties -> new StrawBlock(properties.mapColor(MapColor.COLOR_YELLOW).sound(SoundType.GRASS)), ModRegistry.blockBuilder());
    public static final RegistrySupplier<Item> CHOCOBO_SADDLE = ModRegistry.registerItem("chocobo_saddle", properties -> new ChocoboSaddleItem((Item.Properties)properties, 0), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> CHOCOBO_SADDLE_BAGS = ModRegistry.registerItem("chocobo_saddle_bags", properties -> new ChocoboSaddleItem((Item.Properties)properties, 18), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> CHOCOBO_SADDLE_PACK = ModRegistry.registerItem("chocobo_saddle_pack", properties -> new ChocoboSaddleItem((Item.Properties)properties, 45), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> YELLOW_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("yellow_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.YELLOW), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> GREEN_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("green_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.GREEN), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> BLUE_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("blue_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.BLUE), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> WHITE_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("white_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.WHITE), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> BLACK_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("black_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.BLACK), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> GOLD_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("gold_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.GOLD), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> PINK_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("pink_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.PINK), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> RED_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("red_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.RED), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> PURPLE_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("purple_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.PURPLE), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> FLAME_CHOCOBO_SPAWN_EGG = ModRegistry.registerItem("flame_chocobo_spawn_egg", properties -> new ChocoboSpawnEggItem((Item.Properties)properties, ChocoboColor.FLAME), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> GYSAHL_GREEN_SEEDS = ModRegistry.registerItem("gysahl_green_seeds", properties -> new CustomBlockNamedItem((Supplier<Block>)GYSAHL_GREEN, (Item.Properties)properties), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> GYSAHL_GREEN_ITEM = ModRegistry.registerItem("gysahl_green", Item::new, ModRegistry.itemBuilder().food(ModFoods.GYSAHL_GREEN));
    public static final RegistrySupplier<Item> CHOCOBO_WHISTLE = ModRegistry.registerItem("chocobo_whistle", Item::new, ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> CHOCOBO_FEATHER = ModRegistry.registerItem("chocobo_feather", Item::new, ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> LOVERLY_GYSAHL_GREEN = ModRegistry.registerItem("loverly_gysahl_green", Item::new, ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> GOLD_GYSAHL = ModRegistry.registerItem("gold_gysahl", Item::new, ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> RED_GYSAHL = ModRegistry.registerItem("red_gysahl", Item::new, ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> PINK_GYSAHL = ModRegistry.registerItem("pink_gysahl", Item::new, ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> CHOCOBO_DRUMSTICK_RAW = ModRegistry.registerItem("chocobo_drumstick_raw", Item::new, ModRegistry.itemBuilder().food(ModFoods.CHOCOBO_DRUMSTICK_RAW));
    public static final RegistrySupplier<Item> CHOCOBO_DRUMSTICK_COOKED = ModRegistry.registerItem("chocobo_drumstick_cooked", Item::new, ModRegistry.itemBuilder().food(ModFoods.CHOCOBO_DRUMSTICK_COOKED));
    public static final RegistrySupplier<Item> PICKLED_GYSAHL_RAW = ModRegistry.registerItem("pickled_gysahl_raw", Item::new, ModRegistry.itemBuilder().food(ModFoods.PICKLED_GYSAHL_RAW));
    public static final RegistrySupplier<Item> PICKLED_GYSAHL_COOKED = ModRegistry.registerItem("pickled_gysahl_cooked", Item::new, ModRegistry.itemBuilder().food(ModFoods.PICKLED_GYSAHL_COOKED));
    public static final RegistrySupplier<Item> CHOCOPEDIA = ModRegistry.registerItem("chocopedia", ChocopediaItem::new, ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> GYSAHL_CAKE = ModRegistry.registerItem("gysahl_cake", properties -> new Item(properties.stacksTo(8)), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> CHOCO_DISGUISE_HELMET = ModRegistry.registerItem("choco_disguise_helmet", properties -> Services.PLATFORM.constructChocoDisguise(ModArmorMaterial.CHOCO_DISGUISE, ArmorType.HELMET, (Item.Properties)properties), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> CHOCO_DISGUISE_CHESTPLATE = ModRegistry.registerItem("choco_disguise_chestplate", properties -> Services.PLATFORM.constructChocoDisguise(ModArmorMaterial.CHOCO_DISGUISE, ArmorType.CHESTPLATE, (Item.Properties)properties), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> CHOCO_DISGUISE_LEGGINGS = ModRegistry.registerItem("choco_disguise_leggings", properties -> Services.PLATFORM.constructChocoDisguise(ModArmorMaterial.CHOCO_DISGUISE, ArmorType.LEGGINGS, (Item.Properties)properties), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> CHOCO_DISGUISE_BOOTS = ModRegistry.registerItem("choco_disguise_boots", properties -> Services.PLATFORM.constructChocoDisguise(ModArmorMaterial.CHOCO_DISGUISE, ArmorType.BOOTS, (Item.Properties)properties), ModRegistry.itemBuilder());
    public static final RegistrySupplier<Item> STRAW_ITEM = ModRegistry.registerItem("straw", properties -> new BlockItem((Block)STRAW.get(), properties), ModRegistry.itemBuilder());

    public static RegistrySupplier<Block> registerBlock(String name, Function<BlockBehaviour.Properties, ? extends Block> func, BlockBehaviour.Properties props) {
        return BLOCKS.register(name, () -> (Block)func.apply(props.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Chococraft.modLoc(name)))));
    }

    public static RegistrySupplier<Item> registerItem(String name, Function<Item.Properties, ? extends Item> func, Item.Properties props) {
        return ITEMS.register(name, () -> (Item)func.apply(props.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Chococraft.modLoc(name)))));
    }

    private static Item.Properties itemBuilder() {
        return new Item.Properties();
    }

    private static BlockBehaviour.Properties blockBuilder() {
        return BlockBehaviour.Properties.of();
    }

    public static void registerCompostables() {
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)GYSAHL_GREEN_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)GYSAHL_GREEN_ITEM.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)LOVERLY_GYSAHL_GREEN.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)GOLD_GYSAHL.get()), 0.65f);
    }
}

