/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.models.armor;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.ArmorStandRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.world.item.equipment.ArmorType;

public class ChocoDisguiseModel
extends HumanoidModel<HumanoidRenderState> {
    private final ArmorType armorType;
    private final ModelPart chocobo_head;
    private final ModelPart chocobo_body;
    private final ModelPart chocobo_right_arm;
    private final ModelPart chocobo_left_arm;
    private final ModelPart chocobo_leg_right;
    private final ModelPart chocobo_leg_left;
    private final ModelPart chocobo_claw_right;
    private final ModelPart chocobo_claw_left;

    public ChocoDisguiseModel(ModelPart root, ArmorType type) {
        super(root);
        this.armorType = type;
        this.chocobo_head = root.getChild("chocobo_head");
        this.chocobo_body = root.getChild("chocobo_body");
        this.chocobo_right_arm = root.getChild("chocobo_right_arm");
        this.chocobo_left_arm = root.getChild("chocobo_left_arm");
        this.chocobo_leg_right = root.getChild("chocobo_leg_right");
        this.chocobo_leg_left = root.getChild("chocobo_leg_left");
        this.chocobo_claw_right = root.getChild("chocobo_claw_right");
        this.chocobo_claw_left = root.getChild("chocobo_claw_left");
    }

    public static LayerDefinition createArmorDefinition() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)1.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition chocobo_head = partdefinition.addOrReplaceChild("chocobo_head", CubeListBuilder.create().texOffs(0, 18).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.ZERO);
        PartDefinition the_head = chocobo_head.addOrReplaceChild("the_head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.2063f, -3.8667f, -9.081f, 6.0f, 6.0f, 12.0f).texOffs(36, 12).addBox(2.0f, -3.0f, -3.0f, 1.0f, 3.0f, 3.0f).texOffs(36, 12).addBox(-3.5f, -3.0f, -3.0f, 1.0f, 3.0f, 3.0f).mirror(), PartPose.offsetAndRotation((float)0.2063f, (float)-10.1333f, (float)-0.919f, (float)0.2618f, (float)0.0f, (float)0.0f));
        the_head.addOrReplaceChild("crest_right", CubeListBuilder.create().texOffs(1, 0).addBox(-0.5f, -4.5f, 0.0f, 1.0f, 7.0f, 4.0f).mirror(), PartPose.offsetAndRotation((float)-2.7063f, (float)-0.3667f, (float)2.919f, (float)0.2094f, (float)-0.384f, (float)0.2094f));
        the_head.addOrReplaceChild("crest_top", CubeListBuilder.create().texOffs(25, 0).addBox(-3.0f, -0.5f, 0.0f, 5.0f, 1.0f, 6.0f), PartPose.offsetAndRotation((float)0.2937f, (float)-2.8667f, (float)2.919f, (float)0.4538f, (float)0.0f, (float)0.0f));
        the_head.addOrReplaceChild("crest_left", CubeListBuilder.create().texOffs(1, 0).addBox(-0.5f, -4.5f, 0.0f, 1.0f, 7.0f, 4.0f), PartPose.offsetAndRotation((float)2.2937f, (float)-0.3667f, (float)2.919f, (float)0.2094f, (float)0.384f, (float)-0.2094f));
        PartDefinition chocobo_body = partdefinition.addOrReplaceChild("chocobo_body", CubeListBuilder.create().texOffs(36, 18).addBox(-4.5f, -0.5f, -2.5f, 9.0f, 13.0f, 5.0f), PartPose.ZERO);
        chocobo_body.addOrReplaceChild("feathers_middle", CubeListBuilder.create().texOffs(102, 93).addBox(-3.5f, 0.5f, -0.5f, 7.0f, 1.0f, 6.0f), PartPose.offsetAndRotation((float)-0.5f, (float)8.0f, (float)2.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        chocobo_body.addOrReplaceChild("feathers_left", CubeListBuilder.create().texOffs(44, 92).addBox(1.5f, -8.5f, -0.5f, 1.0f, 14.0f, 9.0f), PartPose.offsetAndRotation((float)-0.5f, (float)8.0f, (float)2.5f, (float)-0.2094f, (float)0.384f, (float)0.3491f));
        chocobo_body.addOrReplaceChild("feathers_right", CubeListBuilder.create().texOffs(44, 92).addBox(1.5f, -8.5f, -0.5f, 1.0f, 14.0f, 9.0f), PartPose.offsetAndRotation((float)-0.5f, (float)8.0f, (float)2.5f, (float)-0.2094f, (float)-0.384f, (float)-0.3491f));
        partdefinition.addOrReplaceChild("chocobo_right_arm", CubeListBuilder.create().texOffs(0, 36).addBox(-3.5f, -3.0f, -2.5f, 5.0f, 15.0f, 5.0f, new CubeDeformation(-0.25f)).mirror(), PartPose.ZERO);
        partdefinition.addOrReplaceChild("chocobo_left_arm", CubeListBuilder.create().texOffs(20, 36).addBox(-1.5f, -2.5f, -2.5f, 5.0f, 15.0f, 5.0f, new CubeDeformation(-0.25f)).mirror(), PartPose.ZERO);
        partdefinition.addOrReplaceChild("chocobo_leg_right", CubeListBuilder.create().texOffs(0, 56).addBox(-2.6f, -0.5f, -2.6f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.125f)).mirror(), PartPose.ZERO);
        partdefinition.addOrReplaceChild("chocobo_leg_left", CubeListBuilder.create().texOffs(0, 56).addBox(-2.5f, -0.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.125f)).mirror(), PartPose.ZERO);
        PartDefinition chocobo_claw_right = partdefinition.addOrReplaceChild("chocobo_claw_right", CubeListBuilder.create().texOffs(20, 56).addBox(-2.5f, 6.25f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(-0.25f)).mirror(), PartPose.ZERO);
        chocobo_claw_right.addOrReplaceChild("claw_right", CubeListBuilder.create().texOffs(40, 37).addBox(-1.0f, -1.25f, -6.5f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)-1.0f, (float)11.0f, (float)-0.5f, (float)0.0f, (float)0.3054f, (float)0.0f));
        chocobo_claw_right.addOrReplaceChild("claw_left", CubeListBuilder.create().texOffs(40, 37).addBox(0.0f, -1.25f, -5.5f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)-1.0f, (float)11.0f, (float)-0.5f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition chocobo_claw_left = partdefinition.addOrReplaceChild("chocobo_claw_left", CubeListBuilder.create().texOffs(20, 56).addBox(-2.4f, 6.25f, -2.6f, 5.0f, 6.0f, 5.0f, new CubeDeformation(-0.25f)).mirror(), PartPose.ZERO);
        chocobo_claw_left.addOrReplaceChild("claw_right", CubeListBuilder.create().texOffs(40, 37).addBox(-1.0f, -1.25f, -6.5f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)1.0f, (float)11.0f, (float)-0.5f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        chocobo_claw_left.addOrReplaceChild("claw_left", CubeListBuilder.create().texOffs(40, 37).addBox(-2.0f, -1.25f, -5.5f, 2.0f, 2.0f, 7.0f), PartPose.offsetAndRotation((float)1.0f, (float)11.0f, (float)-0.5f, (float)0.0f, (float)0.1745f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(HumanoidRenderState renderState) {
        super.setupAnim(renderState);
        if (renderState instanceof ArmorStandRenderState) {
            ArmorStandRenderState armorStand = (ArmorStandRenderState)renderState;
            super.setupAnim(renderState);
            this.chocobo_head.xRot = (float)Math.PI / 180 * armorStand.headPose.x();
            this.chocobo_head.yRot = (float)Math.PI / 180 * armorStand.headPose.y();
            this.chocobo_head.zRot = (float)Math.PI / 180 * armorStand.headPose.z();
            this.chocobo_head.setPos(0.0f, 1.0f, 0.0f);
            this.chocobo_body.xRot = (float)Math.PI / 180 * armorStand.bodyPose.x();
            this.chocobo_body.yRot = (float)Math.PI / 180 * armorStand.bodyPose.y();
            this.chocobo_body.zRot = (float)Math.PI / 180 * armorStand.bodyPose.z();
            this.chocobo_left_arm.xRot = (float)Math.PI / 180 * armorStand.leftArmPose.x();
            this.chocobo_left_arm.yRot = (float)Math.PI / 180 * armorStand.leftArmPose.y();
            this.chocobo_left_arm.zRot = (float)Math.PI / 180 * armorStand.leftArmPose.z();
            this.chocobo_right_arm.xRot = (float)Math.PI / 180 * armorStand.rightArmPose.x();
            this.chocobo_right_arm.yRot = (float)Math.PI / 180 * armorStand.rightArmPose.y();
            this.chocobo_right_arm.zRot = (float)Math.PI / 180 * armorStand.rightArmPose.z();
            this.chocobo_leg_left.xRot = (float)Math.PI / 180 * armorStand.leftLegPose.x();
            this.chocobo_leg_left.yRot = (float)Math.PI / 180 * armorStand.leftLegPose.y();
            this.chocobo_leg_left.zRot = (float)Math.PI / 180 * armorStand.leftLegPose.z();
            this.chocobo_leg_left.setPos(1.9f, 11.0f, 0.0f);
            this.chocobo_leg_right.xRot = (float)Math.PI / 180 * armorStand.rightLegPose.x();
            this.chocobo_leg_right.yRot = (float)Math.PI / 180 * armorStand.rightLegPose.y();
            this.chocobo_leg_right.zRot = (float)Math.PI / 180 * armorStand.rightLegPose.z();
            this.chocobo_leg_right.setPos(-1.9f, 11.0f, 0.0f);
        } else {
            super.setupAnim(renderState);
            this.setHeadRotation();
            this.setChestRotation();
            this.setLegsRotation();
            this.setBootRotation();
            this.chocobo_head.visible = this.armorType == ArmorType.HELMET;
            this.chocobo_body.visible = this.armorType == ArmorType.CHESTPLATE;
            this.chocobo_right_arm.visible = this.armorType == ArmorType.CHESTPLATE;
            this.chocobo_left_arm.visible = this.armorType == ArmorType.CHESTPLATE;
            this.chocobo_leg_right.visible = this.armorType == ArmorType.LEGGINGS;
            this.chocobo_leg_left.visible = this.armorType == ArmorType.LEGGINGS;
            this.chocobo_claw_right.visible = this.armorType == ArmorType.BOOTS;
            this.chocobo_claw_left.visible = this.armorType == ArmorType.BOOTS;
        }
    }

    public void setHeadRotation() {
        this.chocobo_head.x = this.head.x;
        this.chocobo_head.y = this.head.y;
        this.chocobo_head.z = this.head.z;
        this.setRotation(this.chocobo_head, this.head.xRot, this.head.yRot, this.head.zRot);
    }

    public void setChestRotation() {
        this.chocobo_body.x = this.body.x;
        this.chocobo_body.y = this.body.y;
        this.chocobo_body.z = this.body.z;
        this.chocobo_right_arm.x = this.rightArm.x;
        this.chocobo_right_arm.y = this.rightArm.y;
        this.chocobo_right_arm.z = this.rightArm.z;
        this.chocobo_left_arm.x = this.leftArm.x;
        this.chocobo_left_arm.y = this.leftArm.y;
        this.chocobo_left_arm.z = this.leftArm.z;
        this.setRotation(this.chocobo_body, this.body.xRot, this.body.yRot, this.body.zRot);
        this.setRotation(this.chocobo_right_arm, this.rightArm.xRot, this.rightArm.yRot, this.rightArm.zRot);
        this.setRotation(this.chocobo_left_arm, this.leftArm.xRot, this.leftArm.yRot, this.leftArm.zRot);
    }

    public void setLegsRotation() {
        this.chocobo_leg_right.x = this.rightLeg.x;
        this.chocobo_leg_right.y = this.rightLeg.y;
        this.chocobo_leg_right.z = this.rightLeg.z;
        this.chocobo_leg_left.x = this.leftLeg.x;
        this.chocobo_leg_left.y = this.leftLeg.y;
        this.chocobo_leg_left.z = this.leftLeg.z;
        this.setRotation(this.chocobo_leg_right, this.rightLeg.xRot, this.rightLeg.yRot, this.rightLeg.zRot);
        this.setRotation(this.chocobo_leg_left, this.leftLeg.xRot, this.leftLeg.yRot, this.leftLeg.zRot);
    }

    public void setBootRotation() {
        this.chocobo_claw_right.x = this.rightLeg.x;
        this.chocobo_claw_right.y = this.rightLeg.y;
        this.chocobo_claw_right.z = this.rightLeg.z;
        this.chocobo_claw_left.x = this.leftLeg.x;
        this.chocobo_claw_left.y = this.leftLeg.y;
        this.chocobo_claw_left.z = this.leftLeg.z;
        this.setRotation(this.chocobo_claw_right, this.rightLeg.xRot, this.rightLeg.yRot, this.rightLeg.zRot);
        this.setRotation(this.chocobo_claw_left, this.leftLeg.xRot, this.leftLeg.yRot, this.leftLeg.zRot);
    }

    public void setRotation(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

