/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entity;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.chococraft.Chococraft;
import net.chococraft.common.entity.DefaultNames;
import net.chococraft.common.entity.breeding.BreedingHelper;
import net.chococraft.common.entity.breeding.ChocoboAbilityInfo;
import net.chococraft.common.entity.goal.ChocoboFollowOwnerGoal;
import net.chococraft.common.entity.goal.ChocoboHealInPenGoal;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.chococraft.common.entity.properties.MovementType;
import net.chococraft.common.items.ChocoboSaddleItem;
import net.chococraft.common.items.armor.AbstractChocoDisguiseItem;
import net.chococraft.platform.Services;
import net.chococraft.registry.ModEntities;
import net.chococraft.registry.ModRegistry;
import net.chococraft.registry.ModSounds;
import net.chococraft.utils.RandomHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChocobo
extends TamableAnimal
implements HasCustomInventoryScreen {
    private static final ResourceLocation STEP_HEIGHT_ID = Chococraft.modLoc("step_height");
    private static final String NBTKEY_CHOCOBO_COLOR = "Color";
    private static final String NBTKEY_CHOCOBO_IS_MALE = "Male";
    private static final String NBTKEY_MOVEMENTTYPE = "MovementType";
    protected static final String NBTKEY_SADDLE_ITEM = "Saddle";
    protected static final String NBTKEY_INVENTORY = "Inventory";
    private static final String NBTKEY_CHOCOBO_GENERATION = "Generation";
    private static final String NBTKEY_ALLOWED_FLIGHT = "AllowedFlight";
    private static final EntityDataAccessor<ChocoboColor> PARAM_COLOR = SynchedEntityData.defineId(AbstractChocobo.class, Services.PLATFORM.getColorSerializer());
    private static final EntityDataAccessor<Boolean> PARAM_IS_MALE = SynchedEntityData.defineId(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> PARAM_FED_GOLD_GYSAHL = SynchedEntityData.defineId(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<MovementType> PARAM_MOVEMENT_TYPE = SynchedEntityData.defineId(AbstractChocobo.class, Services.PLATFORM.getMovementSerializer());
    private static final EntityDataAccessor<ItemStack> PARAM_SADDLE_ITEM = SynchedEntityData.defineId(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> ALLOWED_FLIGHT = SynchedEntityData.defineId(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> PARAM_GENERATION = SynchedEntityData.defineId(AbstractChocobo.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private AvoidEntityGoal<Player> chocoboAvoidPlayerGoal;
    private ChocoboHealInPenGoal healInPenGoal;
    private float wingRotation;
    private float destPos;
    private float wingRotDelta;
    public int timeSinceFeatherChance = 0;
    private final ChocoboFollowOwnerGoal follow = new ChocoboFollowOwnerGoal(this, 2.0, 3.0f, 10.0f);

    public AbstractChocobo(EntityType<? extends AbstractChocobo> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new ChocoboFollowOwnerGoal(this, 1.0, 5.0f, 5.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.FLYING_SPEED, 0.0).add(Attributes.MAX_HEALTH, 30.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PARAM_COLOR, (Object)ChocoboColor.YELLOW);
        builder.define(PARAM_IS_MALE, (Object)false);
        builder.define(PARAM_FED_GOLD_GYSAHL, (Object)false);
        builder.define(PARAM_MOVEMENT_TYPE, (Object)MovementType.WANDER);
        builder.define(PARAM_SADDLE_ITEM, (Object)ItemStack.EMPTY);
        builder.define(PARAM_GENERATION, (Object)0);
        builder.define(ALLOWED_FLIGHT, (Object)true);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyIn, EntitySpawnReason reason, @Nullable SpawnGroupData spawnDataIn) {
        if (levelAccessor.getBiome(new BlockPos((Vec3i)this.blockPosition().below())).is(BiomeTags.IS_NETHER)) {
            this.setChocoboColor(ChocoboColor.FLAME);
        }
        this.finalizeChocobo(this);
        return super.finalizeSpawn(levelAccessor, difficultyIn, reason, spawnDataIn);
    }

    private void finalizeChocobo(AbstractChocobo chocobo) {
        chocobo.setMale(this.random.nextBoolean());
        chocobo.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)this.getChocoboColor().getAbilityInfo().getMaxHP());
        chocobo.setHealth(this.getMaxHealth());
        chocobo.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)(this.getChocoboColor().getAbilityInfo().getLandSpeed() / 100.0f));
        chocobo.getAttribute(Attributes.FLYING_SPEED).setBaseValue((double)(this.getChocoboColor().getAbilityInfo().getAirbornSpeed() / 100.0f));
        chocobo.setAllowedFlight(Services.PLATFORM.canChocobosFly());
        this.reassessTameGoals();
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setChocoboColor(ChocoboColor.values()[input.getByteOr(NBTKEY_CHOCOBO_COLOR, (byte)0)]);
        this.setMale(input.getBooleanOr(NBTKEY_CHOCOBO_IS_MALE, false));
        this.setMovementType(MovementType.values()[input.getByteOr(NBTKEY_MOVEMENTTYPE, (byte)0)]);
        this.setGeneration(input.getIntOr(NBTKEY_CHOCOBO_GENERATION, 0));
        Optional wornSaddle = input.read("wornSaddle", ItemStack.OPTIONAL_CODEC);
        wornSaddle.ifPresent(this::setSaddleType);
        this.setAllowedFlight(input.getBooleanOr(NBTKEY_ALLOWED_FLIGHT, false));
        this.reassessTameGoals();
    }

    public void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putByte(NBTKEY_CHOCOBO_COLOR, (byte)this.getChocoboColor().ordinal());
        output.putBoolean(NBTKEY_CHOCOBO_IS_MALE, this.isMale());
        output.putByte(NBTKEY_MOVEMENTTYPE, (byte)this.getMovementType().ordinal());
        output.putInt(NBTKEY_CHOCOBO_GENERATION, this.getGeneration());
        output.store("wornSaddle", ItemStack.OPTIONAL_CODEC, (Object)this.getSaddle());
        output.putBoolean(NBTKEY_ALLOWED_FLIGHT, this.allowedFlight());
    }

    public ChocoboColor getChocoboColor() {
        return (ChocoboColor)((Object)this.entityData.get(PARAM_COLOR));
    }

    public void setChocoboColor(ChocoboColor color) {
        this.entityData.set(PARAM_COLOR, (Object)color);
    }

    public boolean fireImmune() {
        return this.getChocoboColor().getAbilityInfo().isImmuneToFire();
    }

    public boolean isMale() {
        return (Boolean)this.entityData.get(PARAM_IS_MALE);
    }

    public void setMale(boolean isMale) {
        this.entityData.set(PARAM_IS_MALE, (Object)isMale);
    }

    public boolean isFedGoldGysahl() {
        return (Boolean)this.entityData.get(PARAM_FED_GOLD_GYSAHL);
    }

    public void setFedGoldGysahl(boolean value) {
        this.entityData.set(PARAM_FED_GOLD_GYSAHL, (Object)value);
    }

    public MovementType getMovementType() {
        return (MovementType)((Object)this.entityData.get(PARAM_MOVEMENT_TYPE));
    }

    public void setMovementType(MovementType type) {
        this.entityData.set(PARAM_MOVEMENT_TYPE, (Object)type);
    }

    public boolean isSaddled() {
        return !this.getSaddle().isEmpty();
    }

    public ItemStack getSaddle() {
        return (ItemStack)this.entityData.get(PARAM_SADDLE_ITEM);
    }

    protected void setSaddleType(ItemStack saddleStack) {
        ItemStack oldStack = this.getSaddle();
        if (oldStack.getItem() != saddleStack.getItem()) {
            this.entityData.set(PARAM_SADDLE_ITEM, (Object)saddleStack.copy());
            this.reconfigureInventory(oldStack, saddleStack);
        }
    }

    public int getGeneration() {
        return (Integer)this.entityData.get(PARAM_GENERATION);
    }

    public void setGeneration(int value) {
        this.entityData.set(PARAM_GENERATION, (Object)value);
    }

    public boolean allowedFlight() {
        return (Boolean)this.entityData.get(ALLOWED_FLIGHT);
    }

    public void setAllowedFlight(boolean value) {
        this.entityData.set(ALLOWED_FLIGHT, (Object)value);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vec3(0.0, (double)1.65f, 0.0);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return this.canBeControlledBy(livingEntity) ? livingEntity : null;
        }
        return null;
    }

    private boolean canBeControlledBy(LivingEntity entity) {
        return this.isTame() && this.isSaddled();
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        return super.updateInWaterStateAndDoFluidPushing();
    }

    public boolean canStandOnFluid(FluidState fluidState) {
        boolean flag = this.getControllingPassenger() != null && this.getControllingPassenger().jumping;
        return fluidState.is(FluidTags.WATER) && this.getAbilityInfo().canWalkOnWater() && !flag;
    }

    public void travel(Vec3 travelVector) {
        if (this.isAlive()) {
            LivingEntity livingentity = this.getControllingPassenger();
            if (this.isVehicle() && livingentity != null) {
                this.setYRot(livingentity.getYRot());
                this.yRotO = this.getYRot();
                this.setXRot(livingentity.getXRot() * 0.5f);
                this.setRot(this.getYRot(), this.getXRot());
                this.yHeadRot = this.yBodyRot = this.getYRot();
                float strafe = livingentity.xxa * 0.5f;
                float forward = livingentity.zza;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (livingentity.jumping && this.getAbilityInfo().getCanFly() && this.allowedFlight()) {
                    this.setJumping(true);
                    this.jumpFromGround();
                    this.hasImpulse = true;
                    this.moveRelative(this.getChocoboColor().getAbilityInfo().getAirbornSpeed() / 100.0f, travelVector);
                } else if (livingentity.jumping && !this.jumping) {
                    if (this.isInWater()) {
                        if (this.getAbilityInfo().canWalkOnWater()) {
                            if (this.isUnderWater()) {
                                this.jumpInLiquid(FluidTags.WATER);
                            }
                        } else {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(0.01f + this.random.nextFloat() * 0.09f), 0.0));
                        }
                    } else if (this.isInWater() && this.getAbilityInfo().canWalkOnWater()) {
                        this.goDownInWater();
                    } else if (this.onGround()) {
                        this.jumpFromGround();
                        livingentity.setJumping(false);
                        this.setJumping(true);
                    }
                }
                if (this.isLocalInstanceAuthoritative()) {
                    this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    super.travel(new Vec3((double)strafe, travelVector.y, (double)forward));
                } else if (livingentity instanceof Player) {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                if (this.onGround()) {
                    this.setJumping(false);
                }
                this.calculateEntityAnimation(false);
            } else {
                super.travel(travelVector);
            }
        }
    }

    protected ChocoboAbilityInfo getAbilityInfo() {
        return this.getChocoboColor().getAbilityInfo();
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        super.positionRider(passenger, moveFunction);
        if (passenger instanceof Mob && this.getControllingPassenger() == passenger) {
            this.yBodyRot = ((LivingEntity)passenger).yBodyRot;
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        AbstractChocobo babyChocobo = (AbstractChocobo)((EntityType)ModEntities.CHOCOBO.get()).create((Level)level, EntitySpawnReason.BREEDING);
        babyChocobo.setChocoboColor(BreedingHelper.getColor(this, (AbstractChocobo)partner));
        this.finalizeChocobo(babyChocobo);
        this.setFedGoldGysahl(false);
        ((AbstractChocobo)partner).setFedGoldGysahl(false);
        return babyChocobo;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void spawnChildFromBreeding(ServerLevel level, Animal partner) {
        if (partner instanceof AbstractChocobo) {
            AbstractChocobo target = (AbstractChocobo)partner;
            if (this.getChocoboColor() == ChocoboColor.PURPLE && target.getChocoboColor() == ChocoboColor.PURPLE) {
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)ModRegistry.PURPLE_CHOCOBO_SPAWN_EGG.get()), 0.0f);
                }
                this.setAge(6000);
                target.setAge(6000);
                this.resetLove();
                target.resetLove();
                return;
            }
        }
        super.spawnChildFromBreeding(level, partner);
    }

    public boolean canMate(Animal parent) {
        if (parent == this || !(parent instanceof AbstractChocobo)) {
            return false;
        }
        AbstractChocobo otherChocobo = (AbstractChocobo)parent;
        if (!this.isInLove() || !parent.isInLove()) {
            return false;
        }
        return otherChocobo.isMale() != this.isMale();
    }

    public void dropFeather() {
        if (this.level().isClientSide()) {
            return;
        }
        if (this.isBaby()) {
            return;
        }
        this.spawnAtLocation((ServerLevel)this.level(), new ItemStack((ItemLike)ModRegistry.CHOCOBO_FEATHER.get(), 1), 0.0f);
    }

    protected boolean canRide(Entity entityIn) {
        return !this.getSaddle().isEmpty() && super.canRide(entityIn);
    }

    public void aiStep() {
        super.aiStep();
        this.setRot(this.getYRot(), this.getXRot());
        this.resetFallDistance();
        if (this.timeSinceFeatherChance == 3000) {
            this.timeSinceFeatherChance = 0;
            if ((double)((float)Math.random()) < 0.25) {
                this.dropFeather();
            }
        } else {
            ++this.timeSinceFeatherChance;
        }
        if (!this.level().isClientSide() && this.isPassenger() && this.isVehicle()) {
            this.stopRiding();
        }
        if (this.level().isClientSide()) {
            this.destPos += (float)((double)(this.onGround() ? -1 : 4) * 0.3);
            this.destPos = Mth.clamp((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.onGround()) {
                this.wingRotDelta = Math.min(this.wingRotation, 1.0f);
            }
            this.wingRotDelta *= 0.9f;
            this.wingRotation += this.wingRotDelta * 2.0f;
            if (this.onGround()) {
                this.calculateEntityAnimation(false);
            } else {
                this.walkAnimation.position(0.0f);
                this.walkAnimation.setSpeed(0.0f);
            }
        }
    }

    public void tick() {
        Entity entity;
        super.tick();
        if (this.isVehicle() && (entity = this.getFirstPassenger()) instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)entity;
            this.getAbilityInfo().getRiderAbilities().forEach(ability -> {
                passenger.addEffect((MobEffectInstance)ability.get());
                this.addEffect((MobEffectInstance)ability.get());
            });
        }
        this.updateStepHeight();
    }

    private void updateStepHeight() {
        AttributeInstance attributeinstance = this.getAttribute(Attributes.STEP_HEIGHT);
        float stepHeight = this.getAbilityInfo().getStepHeight(true);
        if (attributeinstance != null) {
            attributeinstance.addOrUpdateTransientModifier(new AttributeModifier(STEP_HEIGHT_ID, (double)stepHeight, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is((Item)ModRegistry.LOVERLY_GYSAHL_GREEN.get()) || stack.is((Item)ModRegistry.GOLD_GYSAHL.get()) || stack.is((Item)ModRegistry.GYSAHL_CAKE.get());
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack heldItemStack = player.getItemInHand(hand);
        if (this.isFood(heldItemStack)) {
            boolean fedCake;
            boolean bl = fedCake = heldItemStack.getItem() == ModRegistry.GYSAHL_CAKE.get();
            if (this.isBaby()) {
                if (fedCake) {
                    this.usePlayerItem(player, hand, heldItemStack);
                    this.setBaby(false);
                    return InteractionResult.SUCCESS;
                }
            } else {
                int i = this.getAge();
                if (!this.level().isClientSide() && i == 0 && this.canFallInLove() && !fedCake) {
                    if (heldItemStack.getItem() == ModRegistry.GOLD_GYSAHL.get()) {
                        this.setFedGoldGysahl(true);
                    }
                    this.usePlayerItem(player, hand, heldItemStack);
                    this.setInLove(player);
                    return InteractionResult.SUCCESS;
                }
            }
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
        }
        if (this.level().isClientSide()) {
            return InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isSaddled() && !this.isVehicle() && player.getMainHandItem().isEmpty() && !player.isShiftKeyDown() && !this.isBaby()) {
                player.startRiding((Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (player.isShiftKeyDown() && !this.isBaby() && player.getMainHandItem().isEmpty()) {
                this.openCustomInventoryScreen((Player)((ServerPlayer)player));
                return InteractionResult.SUCCESS;
            }
            if (heldItemStack.is((Item)ModRegistry.CHOCOBO_WHISTLE.get()) && !this.isBaby()) {
                if (this.isOwnedBy((LivingEntity)player)) {
                    if (this.getMovementType() == MovementType.STANDSTILL) {
                        this.playSound((SoundEvent)ModSounds.WHISTLE_SOUND_FOLLOW.get(), 1.0f, 1.0f);
                        this.setNoAi(false);
                        this.goalSelector.addGoal(0, (Goal)this.follow);
                        this.setMovementType(MovementType.FOLLOW_OWNER);
                        player.displayClientMessage((Component)Component.translatable((String)"chococraft.entity_chocobo.chocobo_followcmd"), true);
                    } else if (this.getMovementType() == MovementType.FOLLOW_OWNER) {
                        this.playSound((SoundEvent)ModSounds.WHISTLE_SOUND_WANDER.get(), 1.0f, 1.0f);
                        this.goalSelector.removeGoal((Goal)this.follow);
                        this.setMovementType(MovementType.WANDER);
                        player.displayClientMessage((Component)Component.translatable((String)"chococraft.entity_chocobo.chocobo_wandercmd"), true);
                    } else if (this.getMovementType() == MovementType.WANDER) {
                        this.playSound((SoundEvent)ModSounds.WHISTLE_SOUND_STAY.get(), 1.0f, 1.0f);
                        this.setNoAi(true);
                        this.setMovementType(MovementType.STANDSTILL);
                        player.displayClientMessage((Component)Component.translatable((String)"chococraft.entity_chocobo.chocobo_staycmd"), true);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"chococraft.entity_chocobo.not_owner"), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (heldItemStack.is((Item)ModRegistry.GYSAHL_GREEN_ITEM.get())) {
                if (this.getHealth() != this.getMaxHealth()) {
                    this.usePlayerItem(player, hand, heldItemStack);
                    this.heal(5.0f);
                    this.gameEvent((Holder)GameEvent.EAT, (Entity)this);
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"chococraft.entity_chocobo.heal_fail"), true);
                return InteractionResult.PASS;
            }
            if (this.getChocoboColor() == ChocoboColor.GOLD) {
                if (heldItemStack.getItem() == ModRegistry.RED_GYSAHL.get()) {
                    this.usePlayerItem(player, hand, heldItemStack);
                    this.setChocoboColor(ChocoboColor.RED);
                    return InteractionResult.SUCCESS;
                }
                if (heldItemStack.getItem() == ModRegistry.PINK_GYSAHL.get()) {
                    this.usePlayerItem(player, hand, heldItemStack);
                    this.setChocoboColor(ChocoboColor.PINK);
                    return InteractionResult.SUCCESS;
                }
            }
            if (heldItemStack.getItem() instanceof ChocoboSaddleItem && !this.isSaddled() && !this.isBaby()) {
                this.setSaddled(player, hand, new ItemStack((ItemLike)heldItemStack.getItem()));
                if (!player.getAbilities().instabuild) {
                    heldItemStack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (heldItemStack.is((Item)ModRegistry.GYSAHL_GREEN_ITEM.get())) {
            this.usePlayerItem(player, hand, heldItemStack);
            if ((float)Math.random() < Services.PLATFORM.getTameChance()) {
                this.setOwner((LivingEntity)player);
                this.setTame(true, false);
                if (Services.PLATFORM.nameTamedChocobos() && !this.hasCustomName()) {
                    this.setCustomName((Component)DefaultNames.getRandomName(this.random, this.isMale()));
                }
                player.displayClientMessage((Component)Component.translatable((String)"chococraft.entity_chocobo.tame_success"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"chococraft.entity_chocobo.tame_fail"), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected abstract void setSaddled(Player var1, InteractionHand var2, ItemStack var3);

    protected abstract void reconfigureInventory(ItemStack var1, ItemStack var2);

    protected boolean dropFromLootTable(ServerLevel serverLevel, ResourceKey<LootTable> resourceKey, Function<LootParams.Builder, LootParams> function, BiConsumer<ServerLevel, ItemStack> biConsumer) {
        this.dropInventory();
        return super.dropFromLootTable(serverLevel, resourceKey, function, biConsumer);
    }

    protected abstract void dropInventory();

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.AMBIENT_SOUND.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSounds.AMBIENT_SOUND.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.AMBIENT_SOUND.get();
    }

    protected float getSoundVolume() {
        return 0.6f;
    }

    public int getAmbientSoundInterval() {
        return 24 * (int)(Math.random() * (double)Services.PLATFORM.kwehIntervalLimit());
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader levelReader) {
        if (this.level().getBiome(new BlockPos((Vec3i)this.blockPosition())).is(BiomeTags.IS_NETHER)) {
            return 0.0f;
        }
        return super.getWalkTargetValue(pos, levelReader);
    }

    public void setTame(boolean tame, boolean applyTamingSideEffects) {
        super.setTame(tame, applyTamingSideEffects);
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
        if (this.chocoboAvoidPlayerGoal == null) {
            this.chocoboAvoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 10.0f, 1.0, 1.2, livingEntity -> {
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    int chance = 0;
                    for (EquipmentSlot equipmentSlot : EquipmentSlotGroup.ARMOR) {
                        ItemStack stack;
                        if (equipmentSlot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (stack = player.getItemBySlot(equipmentSlot)).isEmpty() || !(stack.getItem() instanceof AbstractChocoDisguiseItem)) continue;
                        chance += 25;
                    }
                    return !RandomHelper.getChanceResult(this.getRandom(), chance);
                }
                return false;
            });
        }
        if (this.healInPenGoal == null) {
            this.healInPenGoal = new ChocoboHealInPenGoal(this);
        }
        this.goalSelector.removeGoal(this.chocoboAvoidPlayerGoal);
        this.goalSelector.removeGoal((Goal)this.healInPenGoal);
        if (this.isTame()) {
            this.goalSelector.addGoal(4, (Goal)this.healInPenGoal);
        } else {
            this.goalSelector.addGoal(5, this.chocoboAvoidPlayerGoal);
        }
    }

    public static boolean checkChocoboSpawnRules(EntityType<? extends AbstractChocobo> entityType, LevelAccessor levelAccessor, EntitySpawnReason spawnType, BlockPos pos, RandomSource randomSource) {
        if (levelAccessor.getBiome(new BlockPos((Vec3i)pos)).is(BiomeTags.IS_NETHER)) {
            BlockPos blockpos = pos.below();
            return spawnType == EntitySpawnReason.SPAWNER || levelAccessor.getBlockState(blockpos).isValidSpawn((BlockGetter)levelAccessor, blockpos, entityType);
        }
        return levelAccessor.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && AbstractChocobo.isBrightEnoughToSpawn((BlockAndTintGetter)levelAccessor, (BlockPos)pos);
    }
}

