/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entity.goal;

import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.entity.properties.MovementType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;

public class ChocoboFollowOwnerGoal
extends FollowOwnerGoal {
    private final AbstractChocobo chocobo;

    public ChocoboFollowOwnerGoal(AbstractChocobo chocobo, double speedModifier, float startDistance, float stopDistance) {
        super((TamableAnimal)chocobo, speedModifier, startDistance, stopDistance);
        this.chocobo = chocobo;
    }

    public boolean canUse() {
        LivingEntity livingentity = this.chocobo.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.isSpectator()) {
            return false;
        }
        if (this.chocobo.getMovementType() != MovementType.FOLLOW_OWNER) {
            return false;
        }
        if (this.chocobo.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        if (this.chocobo.isOrderedToSit()) {
            return false;
        }
        return !(this.chocobo.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance)) && this.chocobo.getMovementType() == MovementType.FOLLOW_OWNER;
    }
}

