/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.items;

import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.chococraft.registry.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class ChocoboSpawnEggItem
extends Item {
    private final ChocoboColor color;

    public ChocoboSpawnEggItem(Item.Properties properties, ChocoboColor color) {
        super(properties);
        this.color = color;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = context.getItemInHand();
        BlockPos blockPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockState = level.getBlockState(blockPos);
        Player player = context.getPlayer();
        BlockPos pos = blockState.getCollisionShape((BlockGetter)level, blockPos).isEmpty() ? blockPos : blockPos.relative(direction);
        AbstractChocobo chocobo = (AbstractChocobo)((EntityType)ModEntities.CHOCOBO.get()).create((Level)serverLevel, EntitySpawnReason.SPAWN_ITEM_USE);
        if (chocobo != null) {
            if (player != null && player.isCrouching()) {
                chocobo.setAge(-24000);
            }
            chocobo.snapTo((double)pos.getX() + 0.5, (float)pos.getY() + 0.5f, (double)pos.getZ() + 0.5, Mth.wrapDegrees((float)(level.random.nextFloat() * 360.0f)), 0.0f);
            chocobo.yHeadRot = chocobo.getYRot();
            chocobo.yBodyRot = chocobo.getYRot();
            chocobo.setChocoboColor(this.color);
            chocobo.finalizeSpawn((ServerLevelAccessor)serverLevel, level.getCurrentDifficultyAt(chocobo.blockPosition()), EntitySpawnReason.SPAWN_ITEM_USE, null);
            if (level.addFreshEntity((Entity)chocobo)) {
                stack.shrink(1);
                level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, pos);
            }
            chocobo.playAmbientSound();
        }
        return InteractionResult.CONSUME;
    }
}

