/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.neoforge.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.chococraft.Chococraft;
import net.chococraft.platform.Services;
import org.apache.commons.io.FileUtils;

public class BreedingConfig {
    public static final LinkedTreeMap<String, LinkedTreeMap<String, List<LinkedTreeMap<String, String>>>> breedingInfoHashmap = new LinkedTreeMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File INITIAL_FILE = new File(Services.PLATFORM.getConfigDirectory().toFile(), "chococraft-4-breeding.json");

    public static void initializeConfig() {
        if (!INITIAL_FILE.exists()) {
            try {
                InputStream inputStream = BreedingConfig.class.getClassLoader().getResourceAsStream("/breedingDefault.json");
                if (inputStream == null) {
                    Chococraft.LOGGER.error("Unable to locate default breeding config");
                } else {
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)INITIAL_FILE);
                    Chococraft.LOGGER.debug("Generated a default Breeding Config");
                    BreedingConfig.loadConfig();
                }
            }
            catch (Exception e) {
                Chococraft.LOGGER.error("Unable to initialize breeding config");
                Chococraft.LOGGER.error("Trace: ", (Throwable)e);
            }
        }
    }

    public static void loadConfig() {
        if (INITIAL_FILE.exists()) {
            breedingInfoHashmap.clear();
            String fileName = INITIAL_FILE.getName();
            try (FileReader json = new FileReader(INITIAL_FILE);){
                LinkedTreeMap breedingMap = new LinkedTreeMap();
                breedingMap.putAll((Map)GSON.fromJson((Reader)json, Map.class));
                if (!breedingMap.isEmpty()) {
                    breedingInfoHashmap.putAll((Map)breedingMap);
                    Chococraft.LOGGER.debug("Loaded JSON config file {}", (Object)INITIAL_FILE.getAbsolutePath());
                } else {
                    Chococraft.LOGGER.error("Could not load Breeding Config from {}.", (Object)fileName);
                }
            }
            catch (Exception e) {
                Chococraft.LOGGER.error("Unable to load file {}. Please make sure it's a valid json.", (Object)fileName);
                Chococraft.LOGGER.error("Trace: ", (Throwable)e);
            }
        } else {
            Chococraft.LOGGER.error("Could not locate Breeding Config from {}.", (Object)INITIAL_FILE.getAbsolutePath());
            BreedingConfig.initializeConfig();
        }
    }
}

