/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.neoforge.datagen.data;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.chococraft.Chococraft;
import net.chococraft.common.world.worldgen.ModFeatures;
import net.chococraft.neoforge.common.modifier.AddChocoboModifier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ChocoDatapack
extends DatapackBuiltinEntriesProvider {
    public static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, ModFeatures::configuredBootstrap).add(Registries.PLACED_FEATURE, ModFeatures::placedBootstrap).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderGetter placedGetter = context.lookup(Registries.PLACED_FEATURE);
        context.register(ChocoDatapack.createModifierKey("add_plains_chocobos"), (Object)new AddChocoboModifier((HolderSet<Biome>)biomeGetter.getOrThrow(Tags.Biomes.IS_PLAINS)));
        context.register(ChocoDatapack.createModifierKey("add_mountain_chocobos"), (Object)new AddChocoboModifier((HolderSet<Biome>)biomeGetter.getOrThrow(Tags.Biomes.IS_MOUNTAIN)));
        context.register(ChocoDatapack.createModifierKey("add_nether_chocobos"), (Object)new AddChocoboModifier((HolderSet<Biome>)biomeGetter.getOrThrow(BiomeTags.IS_NETHER)));
        context.register(ChocoDatapack.createModifierKey("add_gysahl_green"), (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.getOrThrow(BiomeTags.IS_OVERWORLD), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedGetter.getOrThrow(ModFeatures.PLACED_PATCH_GYSAHL_GREEN)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    });

    public ChocoDatapack(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, Set<String> modIds) {
        super(output, registries, BUILDER, modIds);
    }

    public static ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Chococraft.modLoc(name));
    }
}

