/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.neoforge.platform;

import com.google.gson.internal.LinkedTreeMap;
import java.nio.file.Path;
import java.util.List;
import net.chococraft.common.entity.AbstractChocobo;
import net.chococraft.common.entity.properties.ChocoboColor;
import net.chococraft.common.entity.properties.MovementType;
import net.chococraft.common.inventory.SaddleBagMenu;
import net.chococraft.common.items.armor.AbstractChocoDisguiseItem;
import net.chococraft.neoforge.common.config.BreedingConfig;
import net.chococraft.neoforge.common.config.NeoForgeChocoConfig;
import net.chococraft.neoforge.common.entity.NeoForgeChocobo;
import net.chococraft.neoforge.common.inventory.NeoForgeSaddleBagMenu;
import net.chococraft.neoforge.common.items.NeoForgeChocoDisguiseItem;
import net.chococraft.neoforge.registry.ModDataSerializers;
import net.chococraft.platform.services.IPlatformHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isModLoaded(String modID) {
        return ModList.get().isLoaded(modID);
    }

    @Override
    public EntityType.Builder<? extends AbstractChocobo> constructChocoboEntityType() {
        return EntityType.Builder.of(NeoForgeChocobo::new, (MobCategory)MobCategory.CREATURE).sized(1.2f, 2.8f).clientTrackingRange(64);
    }

    @Override
    public SaddleBagMenu constructMenu(int i, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        return NeoForgeSaddleBagMenu.create(i, inventory, friendlyByteBuf);
    }

    @Override
    public SaddleBagMenu constructMenu(int i, Inventory inventory, AbstractChocobo abstractChocobo) {
        return new NeoForgeSaddleBagMenu(i, inventory, (NeoForgeChocobo)abstractChocobo);
    }

    @Override
    public AbstractChocoDisguiseItem constructChocoDisguise(ArmorMaterial material, ArmorType type, Item.Properties properties) {
        return new NeoForgeChocoDisguiseItem(material, type, properties);
    }

    @Override
    public LinkedTreeMap<String, LinkedTreeMap<String, List<LinkedTreeMap<String, String>>>> getBreedingInfoMap() {
        return BreedingConfig.breedingInfoHashmap;
    }

    @Override
    public float getTameChance() {
        return ((Double)NeoForgeChocoConfig.COMMON.tameChance.get()).floatValue();
    }

    @Override
    public boolean canChocobosFly() {
        return (Boolean)NeoForgeChocoConfig.COMMON.canChocobosFly.get();
    }

    @Override
    public int kwehIntervalLimit() {
        return (Integer)NeoForgeChocoConfig.COMMON.kwehIntervalLimit.get();
    }

    @Override
    public boolean nameTamedChocobos() {
        return (Boolean)NeoForgeChocoConfig.COMMON.nameTamedChocobos.get();
    }

    @Override
    public List<? extends String> getConfiguredMaleNames() {
        return (List)NeoForgeChocoConfig.COMMON.maleNames.get();
    }

    @Override
    public List<? extends String> getConfiguredFemaleNames() {
        return (List)NeoForgeChocoConfig.COMMON.femaleNames.get();
    }

    @Override
    public EntityDataSerializer<ChocoboColor> getColorSerializer() {
        return ModDataSerializers.CHOCOBO_COLOR.get();
    }

    @Override
    public EntityDataSerializer<MovementType> getMovementSerializer() {
        return ModDataSerializers.MOVEMENT_TYPE.get();
    }
}

