package xyz.thewhitedog9487;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2274;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

import java.util.HashSet;
import java.util.Set;
import java.util.SplittableRandom;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;
import static net.minecraft.class_2902.class_2903.field_13203;
import static xyz.thewhitedog9487.ResourceReloaderListener.*;

public class CommandRegister {

    /**
     * 随机数生成器
     */
    final static SplittableRandom SR = new SplittableRandom();

    /**
     * 传送后用于生成保护平台的方块
     */
    final static class_2248 TargetBlock = class_2246.field_10033;

    /**
     * 传送后会被 {@link CommandRegister#TargetBlock} 替换掉的方块
     * <br>
     * 替换中心：被传送目标脚下方块
     * <br>
     * 替换范围：替换中心周围半径为一的正方形区域
     */
    final static Set<class_2248> ReplaceToTargetBlock = Set.of(
            class_2246.field_10124,
            class_2246.field_10243,
            class_2246.field_10543,
            class_2246.field_10382,
            class_2246.field_10164,
            class_2246.field_10479,
            class_2246.field_10597 );

    /**
     * 世界边界
     * <br>
     * @see <a href="https://zh.minecraft.wiki/w/%E4%B8%96%E7%95%8C%E8%BE%B9%E7%95%8C#%E5%A4%A7%E5%B0%8F">Minecraft Wiki (中文)</a>
     * @see <a href="https://minecraft.wiki/w/World_border#General_information">Minecraft Wiki (English)</a>
     */
    final static Integer WorldBorder = (int) 2.9e7;

    /**
     * 执行命令所需权限等级
     * @see net.minecraft.class_3143
     */
    final static byte PermissionLevel = 2;

    /**
     * 使用Fabric API向游戏内注册命令
     * @param Name 根命令名
     * <br>
     * @see <a href="https://docs.fabricmc.net/zh_cn/develop/commands/basics">Fabric Wiki (新样式，中文)</a>
     * @see <a href="https://wiki.fabricmc.net/zh_cn:tutorial:commands">Fabric Wiki (旧样式，中文)</a>
     * @see <a href="https://docs.fabricmc.net/develop/commands/basics">Fabric Wiki (New style,English)</a>
     * @see <a href="https://wiki.fabricmc.net/tutorial:commands">Fabric Wiki (Old style,English)</a>
     */
    public static void Register(String Name){

        CommandRegistrationCallback.EVENT
                .register((dispatcher, registryAccess, environment) ->{
                    dispatcher.register(method_9247(Name)
                            // /rtp
                            .requires(source -> source.method_9259(PermissionLevel))
                            .executes(context -> ExecuteCommand(
                                    context.getSource(),null,null, null))
                            // /rtp <Radius(半径)>
                            .then(method_9244(CommandArgumentName_Radius, IntegerArgumentType.integer(0))
                                    .requires(source -> source.method_9259(PermissionLevel))
                                    .executes(context -> ExecuteCommand(
                                            context.getSource(),
                                            IntegerArgumentType.getInteger(context, CommandArgumentName_Radius),
                                            null,
                                            null)))
                            // /rtp <被传送玩家名(PlayerID)>
                            .then(method_9244(CommandArgumentName_Target, class_2186.method_9309())
                                    .requires(source -> source.method_9259(PermissionLevel))
                                    .executes(context -> ExecuteCommand(
                                            context.getSource(),
                                            null,
                                            class_2186.method_9313(context,CommandArgumentName_Target),
                                            null)))
                            // /rtp <Radius(半径)> <被传送玩家名(PlayerID)>
                            .then(method_9244(CommandArgumentName_Radius, IntegerArgumentType.integer(0))
                                    .then(method_9244(CommandArgumentName_Target, class_2186.method_9309())
                                            .requires(source -> source.method_9259(PermissionLevel))
                                            .executes(context -> ExecuteCommand(
                                                    context.getSource(),
                                                    IntegerArgumentType.getInteger(context, CommandArgumentName_Radius),
                                                    class_2186.method_9313(context,CommandArgumentName_Target),
                                                    null))))
                            // /rtp <被传送玩家名(PlayerID)> <Radius(半径)>
                            .then(method_9244(CommandArgumentName_Target, class_2186.method_9309())
                                    .then(method_9244(CommandArgumentName_Radius, IntegerArgumentType.integer(0))
                                            .requires(source -> source.method_9259(PermissionLevel))
                                            .executes(context -> ExecuteCommand(
                                                    context.getSource(),
                                                    IntegerArgumentType.getInteger(context, CommandArgumentName_Radius),
                                                    class_2186.method_9313(context,CommandArgumentName_Target),
                                                    null))))
//                          // /rtp <Radius(半径)> <Origin(随机中心)>
//                          .then(argument("Radius(半径)", LongArgumentType.longArg())
//                                  .then(argument("Origin(随机中心)",EntityArgumentType.player())
//                                          .requires(source -> source.hasPermissionLevel(PermissionLevel))
//                                          .executes(context -> execute_command_origin(
//                                                  context.getSource(),
//                                                  LongArgumentType.getLong(context, "Radius(半径)"),
//                                                  null,
//                                                  EntityArgumentType.getEntity(context,"Origin(随机中心)")))))
                            // /rtp <Radius(半径)> <OriginPos(随机中心，坐标)>
                            .then(method_9244(CommandArgumentName_Radius, IntegerArgumentType.integer(0))
                                    .then(method_9244(CommandArgumentName_OriginPosition,class_2274.method_9723())
                                            .requires(source -> source.method_9259(PermissionLevel))
                                            .executes(context -> ExecuteCommand(
                                                    context.getSource(),
                                                    IntegerArgumentType.getInteger(context, CommandArgumentName_Radius),
                                                    null,
                                                    class_2274.method_9724(context,CommandArgumentName_OriginPosition)))))
                            // /rtp <Radius(半径)> <被传送玩家名(PlayerID)> <OriginEntity(随机中心，实体)>
                            .then(method_9244(CommandArgumentName_Radius, IntegerArgumentType.integer(0))
                                    .then(method_9244(CommandArgumentName_Target, class_2186.method_9309())
                                            .then(method_9244(CommandArgumentName_OriginEntity,class_2186.method_9309())
                                                    .requires(source -> source.method_9259(PermissionLevel))
                                                    .executes(context -> ExecuteCommand(
                                                            context.getSource(),
                                                            IntegerArgumentType.getInteger(context, CommandArgumentName_Radius),
                                                            class_2186.method_9313(context,CommandArgumentName_Target),
                                                            new class_241( (float) class_2186.method_9313( context,CommandArgumentName_OriginEntity).method_73189().field_1352,
                                                                    (float) class_2186.method_9313( context,CommandArgumentName_OriginEntity).method_73189().field_1350 ))))))
                           // /rtp <Radius(半径)> <被传送玩家名(PlayerID)> <OriginPos(随机中心，坐标)>
                           .then(method_9244(CommandArgumentName_Radius, IntegerArgumentType.integer(0))
                                   .then(method_9244(CommandArgumentName_Target, class_2186.method_9309())
                                           .then(method_9244(CommandArgumentName_OriginPosition,class_2274.method_9723())
                                                   .requires(source -> source.method_9259(PermissionLevel))
                                                   .executes(context -> ExecuteCommand(
                                                           context.getSource(),
                                                           IntegerArgumentType.getInteger(context, CommandArgumentName_Radius),
                                                           class_2186.method_9313(context,CommandArgumentName_Target),
                                                           class_2274.method_9724(context,CommandArgumentName_OriginPosition))))))
                           // /rtp <被传送玩家名(PlayerID)> <Radius(半径)> <OriginEntity(随机中心，实体)>
                           .then(method_9244(CommandArgumentName_Target, class_2186.method_9309())
                                   .then(method_9244(CommandArgumentName_Radius, IntegerArgumentType.integer(0))
                                           .then(method_9244(CommandArgumentName_OriginEntity,class_2186.method_9309())
                                                   .requires(source -> source.method_9259(PermissionLevel))
                                                   .executes(context -> ExecuteCommand(
                                                           context.getSource(),
                                                           IntegerArgumentType.getInteger(context, CommandArgumentName_Radius),
                                                           class_2186.method_9313(context,CommandArgumentName_Target),
                                                           new class_241( (float) class_2186.method_9313( context,CommandArgumentName_OriginEntity).method_73189().field_1352,
                                                                   (float) class_2186.method_9313( context,CommandArgumentName_OriginEntity).method_73189().field_1350 ))))))
                           // /rtp <被传送玩家名(PlayerID)> <Radius(半径)> <OriginPos(随机中心，坐标)>
                           .then(method_9244(CommandArgumentName_Target, class_2186.method_9309())
                                   .then(method_9244(CommandArgumentName_Radius, IntegerArgumentType.integer(0))
                                           .then(method_9244(CommandArgumentName_OriginPosition,class_2274.method_9723())
                                                   .requires(source -> source.method_9259(PermissionLevel))
                                                   .executes(context -> ExecuteCommand(
                                                           context.getSource(),
                                                           IntegerArgumentType.getInteger(context, CommandArgumentName_Radius),
                                                           class_2186.method_9313(context,CommandArgumentName_Target),
                                                           class_2274.method_9724(context,CommandArgumentName_OriginPosition)))))) );});}

    /**
     * 向游戏内注册命令
     * <br>
     * 是 {@link CommandRegister#Register(String)} 的包装器
     * @see CommandRegister#Register(String)
     */
    public static void Register(){
        Register("随机传送");
        Register("rtp");
    }

    /**
     *
     * @param Source 命令执行者
     * @param Radius 随机选择的目的坐标距离参数 {@code Origin} 的最大距离
     * @param Entity 被传送的实体
     * @param Origin 随机选择的目的坐标的中心
     * @return 命令运行是否成功
     */
    static int ExecuteCommand(class_2168 Source, @Nullable Integer Radius, @Nullable class_1297 Entity, @Nullable class_241 Origin){
        class_1297 TargetEntity = Entity == null ? Source.method_44023() : Entity;
        /*
            ↑
            Entity TargetEntity = null;
            if (TargetEntity == null){
                TargetEntity = Source.getPlayer();}
            else{
                TargetEntity = Entity;}
         */
        if (TargetEntity == null) {
            Source.method_9226(()->{ return  class_2561.method_48321("error.no_target","不存在被传送目标，由非玩家物体执行命令时请显式指定被传送玩家ID"); }, true);
            return -1;}
        if (Radius == null){Radius = (int) (WorldBorder - 1e4);}
        // ↑ 远离世界边界
        int Coordinate_X = 0;
        int Coordinate_Z = 0;
        try {
            if (Origin == null){
                Coordinate_X = SR.nextInt(-Radius, Radius + 1);
                Coordinate_Z = SR.nextInt(-Radius, Radius + 1); }
            else{
                Coordinate_X = SR.nextInt((int) Origin.field_1343 - Radius, (int) Origin.field_1343 + Radius + 1);
                Coordinate_Z = SR.nextInt((int) Origin.field_1342 - Radius, (int) Origin.field_1342 + Radius + 1); } }
        catch (IllegalArgumentException e) {
            // 半径为零
            if (Origin == null) {
                Source.method_9226(()->{ return class_2561.method_48321("warning.radius_equal_zero_no_target", "由于你设置的随机半径为0，并且未设置随机中心点坐标，因此什么都不会发生"); },true);
                return -1;}
            else {
                Coordinate_X = (int) Origin.field_1343;
                Coordinate_Z = (int) Origin.field_1342;
                int finalCoordinate_X1 = Coordinate_X;
                int finalCoordinate_Z1 = Coordinate_Z;
                // ↑ "lambda 表达式中使用的变量应为 final 或有效 final"
                Source.method_9226(()->{ return class_2561.method_48322("warning.radius_equal_zero", "警告：由于你设置的随机半径为0，因此在选择出合适高度之后将直接把你传送至%d %d", finalCoordinate_X1, finalCoordinate_Z1); },true);}}
        class_1937 EntityWorld = TargetEntity.method_73183();
        EntityWorld.method_8402(Coordinate_X >> 4, Coordinate_Z >> 4, class_2806.field_12803, true);
        // ↑ 加载目标区块，不然下面获取到的Coordinate_Y一定是-64
        // 必须是 >> 4 ，不能是 / 16
        int Coordinate_Y = EntityWorld.method_8624(field_13203, Coordinate_X, Coordinate_Z);
        class_2338.class_2339 BlockPos = new class_2338.class_2339();
        for (int x = -1; x <= 1; x++) {
            for (int z = -1; z <= 1; z++) {
                // 如果传送到的位置周围一圈是ReplaceToTargetBlock的方块，将其替换为TargetBlock
                BlockPos.method_10103(Coordinate_X - x, Coordinate_Y - 1, Coordinate_Z - z);
                var CurrentBlock = EntityWorld.method_8320(BlockPos).method_26204();
                if ( ReplaceToTargetBlock.contains(CurrentBlock) ) {
                    // 只替换ReplaceToTargetBlock内的方块，其余保留
                    EntityWorld.method_8501(BlockPos, TargetBlock.method_9564());}}}
//        if ( String.valueOf(TargetEntity.getWorld().getBiome(new BlockPos(Math.toIntExact(Coordinate_X), Coordinate_Y, Math.toIntExact(Coordinate_Z))).getKey()).equals("minecraft:the_void") ) {
//            Coordinate_Y++;}
        TargetEntity.method_48105((class_3218) EntityWorld,Coordinate_X + 0.5, Coordinate_Y, Coordinate_Z + 0.5, new HashSet<>(), TargetEntity.method_36454(), TargetEntity.method_36455(), false);
        int finalCoordinate_X = Coordinate_X;
        int finalCoordinate_Z = Coordinate_Z;
        // ↑ "lambda 表达式中使用的变量应为 final 或有效 final"
        final var FeedbackFallbackString = String.format("已将玩家%s传送到%d %d %d", TargetEntity.method_5477().getString(), Coordinate_X, Coordinate_Y, Coordinate_Z);
        Source.method_9226(()->{ return  class_2561.method_48322("info.success", FeedbackFallbackString, TargetEntity.method_5477(), finalCoordinate_X, Coordinate_Y, finalCoordinate_Z); },true);
        return Command.SINGLE_SUCCESS;}
}