/*
 * Decompiled with CFR 0.152.
 */
package com.ashpapi.offhandblocker;

import com.ashpapi.offhandblocker.OffhandConfig;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class KeybindHandler {
    public static final KeyMapping BLOCK_ITEM_KEY = new KeyMapping("key.offhandblocker.block", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 88, "key.categories.offhandblocker");
    public static final KeyMapping UNBLOCK_ITEM_KEY = new KeyMapping("key.offhandblocker.unblock", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "key.categories.offhandblocker");

    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(BLOCK_ITEM_KEY);
        event.register(UNBLOCK_ITEM_KEY);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null) {
            return;
        }
        ItemStack offhandItem = mc.player.getOffhandItem();
        if (offhandItem.isEmpty()) {
            return;
        }
        if (BLOCK_ITEM_KEY.consumeClick()) {
            OffhandConfig.addBlockedItem(offhandItem.getItem());
            mc.player.displayClientMessage((Component)Component.translatable((String)"message.offhandblocker.added", (Object[])new Object[]{offhandItem.getHoverName().getString()}), true);
        }
        if (UNBLOCK_ITEM_KEY.consumeClick()) {
            OffhandConfig.removeBlockedItem(offhandItem.getItem());
            mc.player.displayClientMessage((Component)Component.translatable((String)"message.offhandblocker.removed", (Object[])new Object[]{offhandItem.getHoverName().getString()}), true);
        }
    }
}

