/*
 * Decompiled with CFR 0.152.
 */
package com.ashpapi.offhandblocker;

import com.ashpapi.offhandblocker.OffhandConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="offhandblocker", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class OffhandBlocker {
    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        OffhandBlocker.handleInteraction((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        OffhandBlocker.handleInteraction((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        OffhandBlocker.handleInteraction((PlayerInteractEvent)event);
    }

    private static void handleInteraction(PlayerInteractEvent event) {
        ItemStack stack;
        if (event.getHand() == InteractionHand.OFF_HAND && OffhandConfig.isBlocked((stack = event.getItemStack()).getItem())) {
            event.setCanceled(true);
            event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
            if (event.getEntity() != null) {
                event.getEntity().displayClientMessage((Component)Component.translatable((String)"message.offhandblocker.item_blocked"), true);
            }
        }
    }
}

