/*
 * Decompiled with CFR 0.152.
 */
package com.ashpapi.offhandblocker;

import com.ashpapi.offhandblocker.OffhandConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class OffhandBlockerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"offhandblocker").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"list").executes(ctx -> OffhandBlockerCommand.listBlockedItems((CommandSourceStack)ctx.getSource())))).then(Commands.literal((String)"add").then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> OffhandBlockerCommand.addItem((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"item")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> OffhandBlockerCommand.removeItem((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"item"))))));
    }

    private static int listBlockedItems(CommandSourceStack source) {
        List items = (List)OffhandConfig.BLOCKED_ITEMS.get();
        if (items.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"message.offhandblocker.list.empty"), false);
            return 0;
        }
        source.sendSuccess(() -> Component.translatable((String)"message.offhandblocker.list.title"), false);
        for (String idStr : items) {
            Item item;
            ResourceLocation rl = ResourceLocation.tryParse((String)idStr);
            if (rl == null || (item = (Item)ForgeRegistries.ITEMS.getValue(rl)) == null) continue;
            String name = new ItemStack((ItemLike)item).getHoverName().getString();
            source.sendSuccess(() -> Component.literal((String)("- " + name)), false);
        }
        return items.size();
    }

    private static int addItem(CommandSourceStack source, String input) {
        Item item = OffhandBlockerCommand.findItem(input);
        if (item == null) {
            source.sendFailure((Component)Component.translatable((String)"message.offhandblocker.not_found", (Object[])new Object[]{input}));
            return 0;
        }
        OffhandConfig.addBlockedItem(item);
        source.sendSuccess(() -> Component.translatable((String)"message.offhandblocker.added", (Object[])new Object[]{new ItemStack((ItemLike)item).getHoverName().getString()}), true);
        return 1;
    }

    private static int removeItem(CommandSourceStack source, String input) {
        Item item = OffhandBlockerCommand.findItem(input);
        if (item == null || !OffhandConfig.isBlocked(item)) {
            source.sendFailure((Component)Component.translatable((String)"message.offhandblocker.not_found", (Object[])new Object[]{input}));
            return 0;
        }
        OffhandConfig.removeBlockedItem(item);
        source.sendSuccess(() -> Component.translatable((String)"message.offhandblocker.removed", (Object[])new Object[]{new ItemStack((ItemLike)item).getHoverName().getString()}), true);
        return 1;
    }

    private static Item findItem(String input) {
        Item it;
        ResourceLocation rl = ResourceLocation.tryParse((String)input);
        if (rl != null && (it = (Item)ForgeRegistries.ITEMS.getValue(rl)) != null) {
            return it;
        }
        String search = input.toLowerCase();
        for (Item it2 : ForgeRegistries.ITEMS) {
            if (!it2.getDescriptionId().toLowerCase().contains(search)) continue;
            return it2;
        }
        return null;
    }
}

