/*
 * Decompiled with CFR 0.152.
 */
package com.ashpapi.offhandblocker;

import com.ashpapi.offhandblocker.OffhandConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class OffhandBlockerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"offhandblocker").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"list").executes(ctx -> OffhandBlockerCommand.listBlockedItems((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> OffhandBlockerCommand.addItem((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"item")))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> OffhandBlockerCommand.removeItem((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"item"))))));
    }

    private static int listBlockedItems(CommandSourceStack src) {
        ArrayList blocked = new ArrayList((Collection)OffhandConfig.BLOCKED_ITEMS.get());
        if (blocked.isEmpty()) {
            src.m_288197_(() -> Component.m_237115_((String)"message.offhandblocker.list.empty"), false);
            return 0;
        }
        src.m_288197_(() -> Component.m_237115_((String)"message.offhandblocker.list.title"), false);
        blocked.forEach(idStr -> {
            Item itm = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(idStr));
            if (itm != null) {
                src.m_288197_(() -> Component.m_237113_((String)("- " + new ItemStack((ItemLike)itm).m_41786_().getString())), false);
            }
        });
        return blocked.size();
    }

    private static int addItem(CommandSourceStack src, String in) {
        Item itm = OffhandBlockerCommand.findItem(in);
        if (itm == null) {
            src.m_81352_((Component)Component.m_237110_((String)"message.offhandblocker.not_found", (Object[])new Object[]{in}));
            return 0;
        }
        OffhandConfig.addBlockedItem(itm);
        src.m_288197_(() -> Component.m_237110_((String)"message.offhandblocker.added", (Object[])new Object[]{new ItemStack((ItemLike)itm).m_41786_().getString()}), true);
        return 1;
    }

    private static int removeItem(CommandSourceStack src, String in) {
        Item itm = OffhandBlockerCommand.findItem(in);
        if (itm == null || !OffhandConfig.isBlocked(itm)) {
            src.m_81352_((Component)Component.m_237110_((String)"message.offhandblocker.not_found", (Object[])new Object[]{in}));
            return 0;
        }
        OffhandConfig.removeBlockedItem(itm);
        src.m_288197_(() -> Component.m_237110_((String)"message.offhandblocker.removed", (Object[])new Object[]{new ItemStack((ItemLike)itm).m_41786_().getString()}), true);
        return 1;
    }

    private static Item findItem(String input) {
        Item byId;
        ResourceLocation id = ResourceLocation.m_135820_((String)input.toLowerCase());
        if (id != null && (byId = (Item)ForgeRegistries.ITEMS.getValue(id)) != null) {
            return byId;
        }
        return ForgeRegistries.ITEMS.getValues().stream().filter(i -> i.m_41466_().getString().toLowerCase().contains(input.toLowerCase())).findFirst().orElse(null);
    }
}

