/*
 * Decompiled with CFR 0.152.
 */
package com.ashpapi.offhandblocker;

import com.ashpapi.offhandblocker.OffhandConfig;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class KeybindHandler {
    private static final Minecraft mc = Minecraft.getInstance();
    public static final KeyMapping BLOCK_ITEM_KEY = new KeyMapping("key.offhandblocker.block", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 88, "key.categories.offhandblocker");
    public static final KeyMapping UNBLOCK_ITEM_KEY = new KeyMapping("key.offhandblocker.unblock", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "key.categories.offhandblocker");

    public static void registerKeyHandler() {
        MinecraftForge.EVENT_BUS.register((Object)new KeybindHandler());
    }

    public static void onRegisterKeybinds(RegisterKeyMappingsEvent event) {
        event.register(BLOCK_ITEM_KEY);
        event.register(UNBLOCK_ITEM_KEY);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || KeybindHandler.mc.player == null || KeybindHandler.mc.screen != null) {
            return;
        }
        ItemStack off = KeybindHandler.mc.player.getOffhandItem();
        if (off.isEmpty()) {
            return;
        }
        while (BLOCK_ITEM_KEY.consumeClick()) {
            OffhandConfig.addBlockedItem(off.getItem());
            KeybindHandler.mc.player.displayClientMessage((Component)Component.translatable((String)"message.offhandblocker.added"), true);
        }
        while (UNBLOCK_ITEM_KEY.consumeClick()) {
            OffhandConfig.removeBlockedItem(off.getItem());
            KeybindHandler.mc.player.displayClientMessage((Component)Component.translatable((String)"message.offhandblocker.removed"), true);
        }
    }
}

