/*
 * Decompiled with CFR 0.152.
 */
package com.ashpapi.offhandblocker;

import com.ashpapi.offhandblocker.OffhandConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="offhandblocker", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class OffhandBlocker {
    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem ev) {
        if (ev.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        ItemStack st = ev.getItemStack();
        if (OffhandConfig.isBlocked(st.getItem())) {
            ev.setCanceled(true);
            ev.setCancellationResult(InteractionResult.FAIL);
            ev.getEntity().displayClientMessage((Component)Component.translatable((String)"message.offhandblocker.item_blocked"), true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock ev) {
        if (ev.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        ItemStack st = ev.getItemStack();
        if (OffhandConfig.isBlocked(st.getItem())) {
            ev.setCanceled(true);
            ev.setCancellationResult(InteractionResult.FAIL);
            ev.getEntity().displayClientMessage((Component)Component.translatable((String)"message.offhandblocker.item_blocked"), true);
        }
    }
}

