/*
 * Decompiled with CFR 0.152.
 */
package com.ashpapi.offhandblocker;

import com.ashpapi.offhandblocker.OffhandConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class OffhandBlockerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> disp) {
        disp.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"offhandblocker").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"list").executes(ctx -> OffhandBlockerCommand.list((CommandSourceStack)ctx.getSource())))).then(Commands.literal((String)"add").then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> OffhandBlockerCommand.add((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"item")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> OffhandBlockerCommand.remove((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"item"))))));
    }

    private static int list(CommandSourceStack src) {
        ArrayList blocked = new ArrayList((Collection)OffhandConfig.BLOCKED_ITEMS.get());
        if (blocked.isEmpty()) {
            src.sendSuccess(() -> Component.translatable((String)"message.offhandblocker.list.empty"), false);
            return 0;
        }
        src.sendSuccess(() -> Component.translatable((String)"message.offhandblocker.list.title"), false);
        blocked.forEach(idStr -> {
            Item itm = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)idStr));
            if (itm != null) {
                src.sendSuccess(() -> Component.literal((String)("- " + new ItemStack((ItemLike)itm).getHoverName().getString())), false);
            }
        });
        return blocked.size();
    }

    private static int add(CommandSourceStack src, String in) {
        Item itm = OffhandBlockerCommand.find(in);
        if (itm == null) {
            src.sendFailure((Component)Component.translatable((String)"message.offhandblocker.not_found", (Object[])new Object[]{in}));
            return 0;
        }
        OffhandConfig.addBlockedItem(itm);
        src.sendSuccess(() -> Component.translatable((String)"message.offhandblocker.added", (Object[])new Object[]{new ItemStack((ItemLike)itm).getHoverName().getString()}), true);
        return 1;
    }

    private static int remove(CommandSourceStack src, String in) {
        Item itm = OffhandBlockerCommand.find(in);
        if (itm == null || !OffhandConfig.isBlocked(itm)) {
            src.sendFailure((Component)Component.translatable((String)"message.offhandblocker.not_found", (Object[])new Object[]{in}));
            return 0;
        }
        OffhandConfig.removeBlockedItem(itm);
        src.sendSuccess(() -> Component.translatable((String)"message.offhandblocker.removed", (Object[])new Object[]{new ItemStack((ItemLike)itm).getHoverName().getString()}), true);
        return 1;
    }

    private static Item find(String input) {
        Item byId;
        ResourceLocation id = ResourceLocation.tryParse((String)input.toLowerCase());
        if (id != null && (byId = (Item)ForgeRegistries.ITEMS.getValue(id)) != null) {
            return byId;
        }
        return ForgeRegistries.ITEMS.getValues().stream().filter(i -> i.getDescription().getString().toLowerCase().contains(input.toLowerCase())).findFirst().orElse(null);
    }
}

