/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef;

import com.cinemamod.mcef.CefUtil;
import com.cinemamod.mcef.MCEFApp;
import com.cinemamod.mcef.MCEFBrowser;
import com.cinemamod.mcef.MCEFClient;
import com.cinemamod.mcef.MCEFPlatform;
import com.cinemamod.mcef.MCEFSettings;
import com.cinemamod.mcef.ModScheme;
import com.cinemamod.mcef.listeners.MCEFInitListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import net.minecraft.class_310;
import org.cef.misc.CefCursorType;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MCEF {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MCEF");
    private static MCEFSettings settings;
    private static MCEFApp app;
    private static MCEFClient client;
    private static final ArrayList<MCEFInitListener> awaitingInit;
    private static final HashMap<CefCursorType, Long> CEF_TO_GLFW_CURSORS;

    public static void scheduleForInit(MCEFInitListener task) {
        awaitingInit.add(task);
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static MCEFSettings getSettings() {
        if (settings == null) {
            settings = new MCEFSettings();
            try {
                settings.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return settings;
    }

    public static boolean initialize() {
        MCEF.getLogger().info("Initializing CEF on " + MCEFPlatform.getPlatform().getNormalizedName() + "...");
        if (CefUtil.init()) {
            app = new MCEFApp(CefUtil.getCefApp());
            client = new MCEFClient(CefUtil.getCefClient());
            awaitingInit.forEach(t -> t.onInit(true));
            awaitingInit.clear();
            MCEF.getLogger().info("Chromium Embedded Framework initialized");
            app.getHandle().registerSchemeHandlerFactory("mod", "", (browser, frame, url, request) -> new ModScheme(request.getURL()));
            MCEFPlatform platform = MCEFPlatform.getPlatform();
            if (platform.isLinux() || platform.isWindows()) {
                Runtime.getRuntime().addShutdownHook(new Thread(MCEF::shutdown, "MCEF-Shutdown"));
            } else if (platform.isMacOS()) {
                CefUtil.getCefApp().macOSTerminationRequestRunnable = () -> {
                    MCEF.shutdown();
                    class_310.method_1551().method_1592();
                };
            }
            return true;
        }
        awaitingInit.forEach(t -> t.onInit(false));
        awaitingInit.clear();
        MCEF.getLogger().error("Could not initialize Chromium Embedded Framework");
        MCEF.shutdown();
        return false;
    }

    public static MCEFApp getApp() {
        MCEF.assertInitialized();
        return app;
    }

    public static MCEFClient getClient() {
        MCEF.assertInitialized();
        return client;
    }

    public static MCEFBrowser createBrowser(String url, boolean transparent) {
        MCEF.assertInitialized();
        MCEFBrowser browser = new MCEFBrowser(client, url, transparent);
        browser.setCloseAllowed();
        browser.createImmediately();
        return browser;
    }

    public static MCEFBrowser createBrowser(String url, boolean transparent, int width, int height) {
        MCEF.assertInitialized();
        MCEFBrowser browser = new MCEFBrowser(client, url, transparent);
        browser.setCloseAllowed();
        browser.createImmediately();
        browser.resize(width, height);
        return browser;
    }

    public static boolean isInitialized() {
        return client != null;
    }

    public static void shutdown() {
        if (MCEF.isInitialized()) {
            CefUtil.shutdown();
            client = null;
            app = null;
        }
    }

    private static void assertInitialized() {
        if (!MCEF.isInitialized()) {
            throw new RuntimeException("Chromium Embedded Framework was never initialized.");
        }
    }

    public static String getJavaCefCommit() throws IOException {
        if (System.getProperty("mcef.java.cef.commit") != null) {
            return System.getProperty("mcef.java.cef.commit");
        }
        Enumeration<URL> resources = MCEF.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        HashMap commits = new HashMap(1);
        resources.asIterator().forEachRemaining(resource -> {
            Properties properties = new Properties();
            try {
                properties.load(resource.openStream());
                if (properties.containsKey("java-cef-commit")) {
                    commits.put(resource.getFile(), properties.getProperty("java-cef-commit"));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        if (!commits.isEmpty()) {
            return (String)commits.get(commits.keySet().stream().toList().get(0));
        }
        ProcessBuilder processBuilder = new ProcessBuilder("git", "submodule", "status", "common/java-cef");
        processBuilder.directory(new File("../../"));
        Process process = processBuilder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = reader.readLine();
        if (line != null) {
            String[] parts = line.trim().split(" ");
            return parts[0].replace("+", "");
        }
        return null;
    }

    static long getGLFWCursorHandle(CefCursorType cursorType) {
        if (CEF_TO_GLFW_CURSORS.containsKey((Object)cursorType)) {
            return CEF_TO_GLFW_CURSORS.get((Object)cursorType);
        }
        long glfwCursorHandle = GLFW.glfwCreateStandardCursor((int)cursorType.glfwId);
        CEF_TO_GLFW_CURSORS.put(cursorType, glfwCursorHandle);
        return glfwCursorHandle;
    }

    static {
        awaitingInit = new ArrayList();
        CEF_TO_GLFW_CURSORS = new HashMap();
    }
}

