/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef;

import com.cinemamod.mcef.MCEFDirectTexture;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.class_1044;
import net.minecraft.class_10868;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL12;

public class MCEFRenderer {
    private final boolean transparent;
    private GpuTexture texture;
    private int textureWidth = 0;
    private int textureHeight = 0;
    private class_2960 textureLocation;
    private MCEFDirectTexture directTexture;
    private boolean textureRegistered = false;

    protected MCEFRenderer(boolean transparent) {
        this.transparent = transparent;
        String uniqueId = UUID.randomUUID().toString().toLowerCase().replace("-", "");
        this.textureLocation = class_2960.method_60655((String)"mcef", (String)("browser_" + uniqueId));
    }

    public void initialize() {
        this.directTexture = new MCEFDirectTexture();
        class_310.method_1551().method_1531().method_4616(this.textureLocation, (class_1044)this.directTexture);
        this.textureRegistered = true;
    }

    public GpuTexture getTexture() {
        return this.texture;
    }

    public class_2960 getTextureLocation() {
        return this.textureLocation;
    }

    public boolean isTextureReady() {
        return this.texture != null && this.textureRegistered && this.directTexture != null;
    }

    public int getTextureID() {
        if (this.texture instanceof class_10868) {
            return ((class_10868)this.texture).method_68427();
        }
        return 0;
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    protected void cleanup() {
        if (this.texture != null) {
            this.texture.close();
            this.texture = null;
        }
        if (this.textureRegistered && this.textureLocation != null) {
            class_310.method_1551().method_1531().method_4615(this.textureLocation);
            this.textureRegistered = false;
        }
    }

    protected void onPaint(ByteBuffer buffer, int width, int height) {
        GpuTexture gpuTexture;
        if (this.texture == null || this.textureWidth != width || this.textureHeight != height) {
            GpuTexture gpuTexture2;
            if (this.texture != null) {
                this.texture.close();
            }
            String label = "MCEF Browser Texture " + width + "x" + height;
            this.texture = RenderSystem.getDevice().createTexture(label, 5, TextureFormat.RGBA8, width, height, 1, 1);
            this.texture.setTextureFilter(FilterMode.LINEAR, FilterMode.LINEAR, false);
            this.texture.setAddressMode(AddressMode.CLAMP_TO_EDGE);
            this.textureWidth = width;
            this.textureHeight = height;
            if (this.directTexture != null && (gpuTexture2 = this.texture) instanceof class_10868) {
                class_10868 glTexture = (class_10868)gpuTexture2;
                this.directTexture.setDirectTextureId(glTexture.method_68427(), width, height);
            }
        }
        if ((gpuTexture = this.texture) instanceof class_10868) {
            class_10868 glTexture = (class_10868)gpuTexture;
            GlStateManager._bindTexture((int)glTexture.method_68427());
            GlStateManager._pixelStore((int)3314, (int)width);
            GlStateManager._pixelStore((int)3316, (int)0);
            GlStateManager._pixelStore((int)3315, (int)0);
            GL12.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (ByteBuffer)buffer);
        }
    }

    protected void onPaint(ByteBuffer buffer, int x, int y, int width, int height) {
        GpuTexture gpuTexture = this.texture;
        if (gpuTexture instanceof class_10868) {
            class_10868 glTexture = (class_10868)gpuTexture;
            GlStateManager._bindTexture((int)glTexture.method_68427());
            GL12.glTexSubImage2D((int)3553, (int)0, (int)x, (int)y, (int)width, (int)height, (int)32993, (int)33639, (ByteBuffer)buffer);
        }
    }
}

