/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef;

import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.TextureFormat;
import net.minecraft.client.renderer.texture.AbstractTexture;

public class MCEFDirectTexture
extends AbstractTexture {
    private int width;
    private int height;

    public void setDirectTextureId(int textureId, int width, int height) {
        if (this.textureView != null) {
            this.textureView.close();
            this.textureView = null;
        }
        this.texture = null;
        if (textureId > 0) {
            this.texture = new DirectGlTexture(textureId, width, height);
            this.textureView = RenderSystem.getDevice().createTextureView(this.texture);
            this.width = width;
            this.height = height;
        } else {
            this.texture = null;
            this.width = 0;
            this.height = 0;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void close() {
        if (this.textureView != null) {
            this.textureView.close();
            this.textureView = null;
        }
        this.texture = null;
    }

    private static class DirectGlTexture
    extends GlTexture {
        private final int width;
        private final int height;

        protected DirectGlTexture(int textureId, int width, int height) {
            super(4, "MCEF Direct Texture", TextureFormat.RGBA8, width, height, 1, 1, textureId);
            this.width = width;
            this.height = height;
            this.closed = false;
        }

        public void close() {
        }

        public int getWidth(int mipLevel) {
            return this.width >> mipLevel;
        }

        public int getHeight(int mipLevel) {
            return this.height >> mipLevel;
        }
    }
}

