/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef.internal;

import com.cinemamod.mcef.internal.MCEFDownloadListener;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix3x2fStack;

public class MCEFDownloaderMenu
extends Screen {
    private final Screen menu;

    public MCEFDownloaderMenu(Screen menu) {
        super((Component)Component.literal((String)"MCEF is downloading required libraries...").withStyle(ChatFormatting.GOLD));
        this.menu = menu;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        double cx = (double)this.width / 2.0;
        double cy = (double)this.height / 2.0;
        double progressBarHeight = 14.0;
        double progressBarWidth = (double)this.width / 3.0;
        Matrix3x2fStack matrix = graphics.pose();
        matrix.pushMatrix();
        matrix.translate((float)cx, (float)cy);
        matrix.translate((float)(-progressBarWidth / 2.0), (float)(-progressBarHeight / 2.0));
        graphics.fill(0, 0, (int)progressBarWidth, (int)progressBarHeight, -1);
        graphics.fill(2, 2, (int)progressBarWidth - 2, (int)progressBarHeight - 2, -16777215);
        graphics.fill(4, 4, (int)((progressBarWidth - 4.0) * (double)MCEFDownloadListener.INSTANCE.getProgress()), (int)progressBarHeight - 4, -1);
        matrix.popMatrix();
        String[] text = new String[]{MCEFDownloadListener.INSTANCE.getTask(), Math.round(MCEFDownloadListener.INSTANCE.getProgress() * 100.0f) + "%"};
        Objects.requireNonNull(this.font);
        int n = 9 / 2;
        Objects.requireNonNull(this.font);
        int oSet = n + (9 + 2) * (text.length + 2) + 4;
        matrix.pushMatrix();
        matrix.translate((float)cx, (float)(cy - (double)oSet));
        graphics.drawString(this.font, this.title, (int)(-((double)this.font.width((FormattedText)this.title) / 2.0)), 0, -1);
        int index = 0;
        for (String s : text) {
            if (index == 1) {
                Objects.requireNonNull(this.font);
                matrix.translate(0.0f, 9.0f + 2.0f);
            }
            Objects.requireNonNull(this.font);
            matrix.translate(0.0f, 9.0f + 2.0f);
            graphics.drawString(this.font, s, (int)(-((double)this.font.width(s) / 2.0)), 0, -1);
            ++index;
        }
        matrix.popMatrix();
    }

    public void tick() {
        if (MCEFDownloadListener.INSTANCE.isDone() || MCEFDownloadListener.INSTANCE.isFailed()) {
            this.onClose();
            Minecraft.getInstance().setScreen(this.menu);
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean isPauseScreen() {
        return true;
    }
}

