/*
 * Decompiled with CFR 0.152.
 */
package org.cef.misc;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;

public class DataPointer {
    private final long address;
    private ByteBuffer dataBuffer;
    boolean initialized = false;
    int alignment = 3;
    private static final MethodHandle memByteBuffer;

    public DataPointer(long address) {
        this.address = address;
    }

    public DataPointer forCapacity(int capacity) {
        try {
            this.dataBuffer = memByteBuffer.invoke(this.address, capacity);
            this.initialized = true;
            return this;
        }
        catch (Throwable err) {
            throw new RuntimeException("Failed to invoke memByteBuffer?", err);
        }
    }

    public DataPointer withAlignment(int alignment) {
        this.alignment = alignment;
        return this;
    }

    public long getAddress() {
        return this.address;
    }

    public DataPointer getData(int offset) {
        if (!this.initialized) {
            throw new RuntimeException("DataPoint#forCapacity must be called before the data can be accessed.");
        }
        return new DataPointer(this.dataBuffer.getLong(offset << this.alignment));
    }

    public long getLong(int offset) {
        if (!this.initialized) {
            throw new RuntimeException("DataPoint#forCapacity must be called before the data can be accessed.");
        }
        return this.dataBuffer.getLong(offset << this.alignment);
    }

    public int getInt(int offset) {
        if (!this.initialized) {
            throw new RuntimeException("DataPoint#forCapacity must be called before the data can be accessed.");
        }
        return this.dataBuffer.getInt(offset << this.alignment);
    }

    public short getShort(int offset) {
        if (!this.initialized) {
            throw new RuntimeException("DataPoint#forCapacity must be called before the data can be accessed.");
        }
        return this.dataBuffer.getShort(offset << this.alignment);
    }

    public byte getByte(int offset) {
        if (!this.initialized) {
            throw new RuntimeException("DataPoint#forCapacity must be called before the data can be accessed.");
        }
        return this.dataBuffer.get(offset << this.alignment);
    }

    public double getDouble(int offset) {
        if (!this.initialized) {
            throw new RuntimeException("DataPoint#forCapacity must be called before the data can be accessed.");
        }
        return this.dataBuffer.getDouble(offset << this.alignment);
    }

    public float getFloat(int offset) {
        if (!this.initialized) {
            throw new RuntimeException("DataPoint#forCapacity must be called before the data can be accessed.");
        }
        return this.dataBuffer.getFloat(offset << this.alignment);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> clz = Class.forName("org.lwjgl.system.MemoryUtil", false, lookup.lookupClass().getClassLoader());
            memByteBuffer = lookup.findStatic(clz, "memByteBuffer", MethodType.methodType(ByteBuffer.class, new Class[]{Long.TYPE, Integer.TYPE}));
        }
        catch (Throwable err) {
            System.err.println("Could not find LWJGL MemoryUtil's memByteBuffer method.\nAre you using LWJGL 3.x?");
            throw new RuntimeException(err);
        }
    }
}

