/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.api.inkAction.InkAction;
import fr.loudo.narrativecraft.events.OnHudRender;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.narrative.story.inkAction.ShakeScreenInkAction;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GameRenderer.class})
public class GameRendererMixin {
    @Inject(method={"getFov"}, at={@At(value="RETURN")}, cancellable=true)
    public void narrativecraft$getZoomLevel(CallbackInfoReturnable<Double> callbackInfo) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)player);
        if (playerSession == null) {
            return;
        }
        if (playerSession.getCurrentCamera() == null) {
            return;
        }
        callbackInfo.setReturnValue((Object)playerSession.getCurrentCamera().getFov());
    }

    @Inject(method={"bobHurt"}, at={@At(value="RETURN")})
    public void narrativecraft$applyInkShakeScreen(PoseStack poseStack, float partialTicks, CallbackInfo ci) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)player);
        if (playerSession == null) {
            return;
        }
        List<InkAction> inkActionsShake = playerSession.getClientSideInkActions().stream().filter(inkAction -> inkAction instanceof ShakeScreenInkAction).toList();
        for (InkAction shakeScreenInkAction : inkActionsShake) {
            shakeScreenInkAction.render(poseStack, partialTicks);
        }
    }

    @Redirect(method={"render"}, at=@At(value="NEW", target="(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;)Lnet/minecraft/client/gui/GuiGraphics;"))
    private GuiGraphics narrativecraft$hudRender(Minecraft minecraft, MultiBufferSource.BufferSource bufferSource) {
        GuiGraphics guigraphics = new GuiGraphics(minecraft, bufferSource);
        OnHudRender.controllerHudInfo(guigraphics);
        OnHudRender.inkActionRender(guigraphics, minecraft.m_91296_());
        OnHudRender.dialogRender(guigraphics, minecraft.m_91296_());
        OnHudRender.saveIconRender(guigraphics, minecraft.m_91296_());
        OnHudRender.storyDebugRender(guigraphics, minecraft.m_91296_());
        return guigraphics;
    }

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;getXRot()F")})
    private void narrativecraft$rotateCamera(float partialTicks, long finishTimeNano, PoseStack poseStack, CallbackInfo ci) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        PlayerSession playerSession = NarrativeCraftMod.getInstance().getPlayerSessionManager().getSessionByPlayer((Player)player);
        if (playerSession == null) {
            return;
        }
        if (playerSession.getCurrentCamera() == null) {
            return;
        }
        poseStack.m_252781_(Axis.f_252403_.m_252961_((float)Math.toRadians(playerSession.getCurrentCamera().getRoll())));
    }
}

