/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.character;

import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import fr.loudo.narrativecraft.narrative.character.CharacterModel;
import fr.loudo.narrativecraft.narrative.character.CharacterType;
import fr.loudo.narrativecraft.util.Util;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class CharacterStory
extends NarrativeEntry {
    private transient EntityType<?> entityType;
    private String birthDate;
    private CharacterType characterType;
    private CharacterModel model;
    private int entityTypeId;

    public CharacterStory(String name, String description, String day, String month, String year, CharacterModel model, CharacterType characterType) {
        super(name, description);
        this.birthDate = day + "/" + month + "/" + year;
        this.characterType = characterType;
        this.model = model;
        this.entityType = EntityType.f_20532_;
        this.entityTypeId = BuiltInRegistries.f_256780_.m_7447_(this.entityType);
    }

    public void updateEntityType(EntityType<?> entityType) {
        EntityType<?> oldEntityType = this.entityType;
        int oldEntityTypeId = this.entityTypeId;
        try {
            this.entityType = entityType;
            this.entityTypeId = BuiltInRegistries.f_256780_.m_7447_(entityType);
            NarrativeCraftFile.updateCharacterData(this, this);
        }
        catch (IOException e) {
            this.entityType = oldEntityType;
            this.entityTypeId = oldEntityTypeId;
            Util.sendCrashMessage((Player)Minecraft.m_91087_().f_91074_, e);
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    public CharacterType getCharacterType() {
        return this.characterType;
    }

    public void setCharacterType(CharacterType characterType) {
        this.characterType = characterType;
    }

    public CharacterModel getModel() {
        return this.model;
    }

    public void setModel(CharacterModel model) {
        this.model = model;
    }

    public void setEntityType(EntityType<?> entityType) {
        this.entityType = entityType;
    }

    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    public EntityType<?> getEntityType() {
        if (this.entityType == null) {
            this.entityType = EntityType.f_20532_;
        }
        return this.entityType;
    }
}

