/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.character;

import fr.loudo.narrativecraft.mixin.accessor.EntityAccessor;
import fr.loudo.narrativecraft.mixin.accessor.LivingEntityAccessor;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.character.CharacterRuntime;
import fr.loudo.narrativecraft.narrative.character.CharacterStory;
import fr.loudo.narrativecraft.narrative.recording.Location;
import fr.loudo.narrativecraft.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CharacterStoryData {
    private transient CharacterRuntime characterRuntime;
    private final Location location;
    private final List<ItemSlotData> itemSlotDataList = new ArrayList<ItemSlotData>();
    private String poseName = Pose.STANDING.name();
    private byte entityByte;
    private byte livingEntityByte;
    private String skinName = "main.png";
    private transient String oldSkinName = "main.png";
    private boolean isTemplate;

    public CharacterStoryData(CharacterStory characterStory, Location location, boolean isTemplate, Scene scene) {
        this.characterRuntime = new CharacterRuntime(characterStory, this.skinName, null, scene);
        this.location = location;
        this.isTemplate = isTemplate;
    }

    public void spawn(Level level, Environment environment) {
        if (this.isTemplate && environment == Environment.PRODUCTION && this.characterRuntime.getCharacterStory() == null) {
            return;
        }
        this.characterRuntime.getCharacterSkinController().setSkinName(this.skinName);
        this.characterRuntime.getCharacterSkinController().cacheSkins();
        this.characterRuntime.setEntity(Util.createEntityFromCharacter(this.characterRuntime.getCharacterStory(), level));
        this.characterRuntime.getEntity().m_7678_(this.location.x(), this.location.y(), this.location.z(), this.location.yaw(), this.location.pitch());
        this.characterRuntime.getEntity().m_5616_(this.location.yaw());
        this.characterRuntime.getEntity().m_6853_(this.location.onGround());
        try {
            this.characterRuntime.getEntity().m_20124_(Pose.valueOf((String)this.poseName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.applyBytes(this.characterRuntime.getEntity());
        this.applyItems();
    }

    public void applyBytes(LivingEntity entity) {
        entity.m_20088_().m_135381_(EntityAccessor.getDATA_SHARED_FLAGS_ID(), (Object)this.entityByte);
        entity.m_20088_().m_135381_(LivingEntityAccessor.getDATA_LIVING_ENTITY_FLAGS(), (Object)this.livingEntityByte);
    }

    public void applyItems() {
        for (ItemSlotData itemSlotData : this.itemSlotDataList) {
            try {
                this.characterRuntime.getEntity().m_8061_(EquipmentSlot.valueOf((String)itemSlotData.equipmentSlot), itemSlotData.getItem());
            }
            catch (Exception exception) {}
        }
    }

    public void kill() {
        if (this.characterRuntime.getEntity() == null) {
            return;
        }
        this.characterRuntime.getEntity().m_142687_(Entity.RemovalReason.KILLED);
    }

    public void setItems(LivingEntity entity) {
        this.itemSlotDataList.clear();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = entity.m_6844_(equipmentSlot);
            if (!itemStack.m_41619_()) {
                CompoundTag componentsTag = itemStack.m_41783_();
                String itemData = componentsTag == null ? "" : componentsTag.toString();
                this.itemSlotDataList.add(new ItemSlotData(BuiltInRegistries.f_257033_.m_7447_((Object)itemStack.m_41720_()), itemData, equipmentSlot.name()));
                continue;
            }
            this.itemSlotDataList.add(new ItemSlotData(BuiltInRegistries.f_257033_.m_7447_((Object)Items.f_41852_), "", equipmentSlot.name()));
        }
    }

    public byte getLivingEntityByte() {
        return this.livingEntityByte;
    }

    public void setLivingEntityByte(byte livingEntityByte) {
        this.livingEntityByte = livingEntityByte;
    }

    public byte getEntityByte() {
        return this.entityByte;
    }

    public void setEntityByte(byte entityByte) {
        this.entityByte = entityByte;
    }

    public Location getLocation() {
        return this.location;
    }

    public Pose getPose() {
        try {
            return Pose.valueOf((String)this.poseName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void setPose(Pose pose) {
        this.poseName = pose.name();
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(String skinName) {
        this.oldSkinName = this.skinName;
        this.skinName = skinName;
    }

    public String getOldSkinName() {
        if (this.oldSkinName == null) {
            this.oldSkinName = "main.png";
        }
        return this.oldSkinName;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public void setTemplate(boolean template) {
        this.isTemplate = template;
    }

    public CharacterRuntime getCharacterRuntime() {
        return this.characterRuntime;
    }

    public void setCharacterRuntime(CharacterRuntime characterRuntime) {
        this.characterRuntime = characterRuntime;
    }

    public CharacterStory getCharacterStory() {
        return this.characterRuntime.getCharacterStory();
    }

    private record ItemSlotData(int id, String data, String equipmentSlot) {
        public ItemStack getItem() {
            Item item = (Item)BuiltInRegistries.f_257033_.m_7942_(this.id);
            ItemStack itemStack = new ItemStack((ItemLike)item);
            CompoundTag tag = Util.tagFromIdAndComponents(item, this.data);
            itemStack.m_41751_(tag);
            return itemStack;
        }
    }
}

