/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.narrative.recording.actions;

import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.manager.ActionType;
import fr.loudo.narrativecraft.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class PlaceBlockAction
extends Action {
    private int x;
    private int y;
    private int z;
    private String data;

    public PlaceBlockAction(int tick, BlockPos blockPos, BlockState blockState) {
        super(tick, ActionType.BLOCK_PLACE);
        this.x = blockPos.m_123341_();
        this.y = blockPos.m_123342_();
        this.z = blockPos.m_123343_();
        this.data = NbtUtils.m_129202_((BlockState)blockState).toString();
    }

    @Override
    public void execute(PlaybackData playbackData) {
        BlockState blockState = Util.getBlockStateFromData(this.data, playbackData.getEntity().m_9236_().m_9598_());
        if (blockState == null) {
            return;
        }
        BlockPos blockPos = new BlockPos(this.x, this.y, this.z);
        playbackData.getLevel().m_7731_(blockPos, blockState, 3);
        SoundType soundType = blockState.m_60827_();
        playbackData.getLevel().m_245803_(playbackData.getEntity(), blockPos, blockState.m_60827_().m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    @Override
    public void rewind(PlaybackData playbackData) {
        BlockPos blockPos = this.getBlockPos();
        BlockState blockState = Util.getBlockStateFromData(this.data, playbackData.getEntity().m_9236_().m_9598_());
        if (blockState != null) {
            if (blockState.m_60734_() instanceof BedBlock) {
                if (blockState.m_61143_((Property)BedBlock.f_49440_) == BedPart.FOOT) {
                    Direction direction = (Direction)blockState.m_61143_((Property)BedBlock.f_54117_);
                    blockPos = blockPos.m_121945_(direction);
                }
            } else if (blockState.m_60734_() instanceof DoorBlock && blockState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
                blockPos = blockPos.m_7495_();
            }
        }
        playbackData.getLevel().m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }
}

