/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.narrative.NarrativeEntry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class GenericSelectionScreen<T extends NarrativeEntry>
extends Screen {
    protected final List<T> itemList;
    protected final Consumer<T> consumer;
    protected final T currentSelection;
    protected final String screenTitle;
    protected final Screen lastScreen;
    protected final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private SelectionList<T> selectionList;

    public GenericSelectionScreen(Screen lastScreen, String screenTitle, List<T> itemList, T currentSelection, Consumer<T> consumer) {
        super((Component)Component.m_237113_((String)screenTitle));
        this.lastScreen = lastScreen;
        this.screenTitle = screenTitle;
        this.itemList = itemList;
        this.currentSelection = currentSelection;
        this.consumer = consumer;
    }

    protected void m_7856_() {
        this.addTitle();
        this.addContents();
        this.addFooter();
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_267719_();
    }

    protected void addTitle() {
        GridLayout gridlayout = ((GridLayout)this.layout.m_269471_((LayoutElement)new GridLayout())).m_267612_(4);
        gridlayout.m_264211_().m_264623_();
        GridLayout.RowHelper rowHelper = gridlayout.m_264606_(2);
        rowHelper.m_264139_((LayoutElement)new StringWidget(this.f_96539_, this.f_96547_));
        this.addCustomTitleButtons(rowHelper);
    }

    protected void addCustomTitleButtons(GridLayout.RowHelper rowHelper) {
    }

    protected void addContents() {
        this.selectionList = new SelectionList(this.f_96541_, this);
        this.m_142416_((GuiEventListener)this.selectionList);
    }

    protected void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, p_345997_ -> this.m_7379_()).m_252780_(200).m_253136_());
    }

    protected void m_267719_() {
        this.layout.m_264036_();
        this.selectionList.m_93437_(this.f_96543_, this.f_96544_, this.layout.m_269355_(), this.f_96544_ - this.layout.m_269040_());
    }

    public void m_7379_() {
        SelectionList.Entry entry = (SelectionList.Entry)this.selectionList.m_93511_();
        if (entry == null) {
            this.consumer.accept(null);
        } else {
            this.consumer.accept(entry.getItem());
            this.f_96541_.m_91152_(this.lastScreen);
        }
    }

    protected List<T> getItemList() {
        return this.itemList;
    }

    protected T getCurrentSelection() {
        return this.currentSelection;
    }

    static class SelectionList<T extends NarrativeEntry>
    extends ObjectSelectionList<Entry> {
        private final GenericSelectionScreen<T> parentScreen;

        public SelectionList(Minecraft minecraft, GenericSelectionScreen<T> parentScreen) {
            super(minecraft, parentScreen.f_96543_, parentScreen.f_96544_, 32, parentScreen.f_96544_ - 65, 18);
            this.parentScreen = parentScreen;
            String selectedName = "";
            if (parentScreen.getCurrentSelection() != null) {
                selectedName = ((NarrativeEntry)parentScreen.getCurrentSelection()).getName();
            }
            for (NarrativeEntry item : parentScreen.getItemList()) {
                Entry entry = new Entry(this, item);
                this.m_7085_((AbstractSelectionList.Entry)entry);
                String itemName = item.getName();
                if (!selectedName.equalsIgnoreCase(itemName)) continue;
                this.m_6987_((AbstractSelectionList.Entry)entry);
            }
            if (this.m_93511_() != null) {
                this.m_93494_((AbstractSelectionList.Entry)((Entry)this.m_93511_()));
            }
        }

        public static class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private final T item;
            final /* synthetic */ SelectionList this$0;

            public Entry(T item) {
                this.this$0 = this$0;
                this.item = item;
            }

            public T getItem() {
                return this.item;
            }

            public void m_6311_(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, int i6, boolean isSelected, float partialTick) {
                String displayName = ((NarrativeEntry)this.item).getName();
                guiGraphics.m_280137_(this.this$0.parentScreen.f_96547_, displayName, this.this$0.f_93388_ / 2, y + 3, -1);
            }

            public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
                if (CommonInputs.m_278691_((int)keyCode)) {
                    this.select();
                    this.this$0.parentScreen.m_7379_();
                    return true;
                }
                return super.m_7933_(keyCode, scanCode, modifiers);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                this.select();
                return super.m_6375_(mouseX, mouseY, button);
            }

            private void select() {
                this.this$0.m_6987_((AbstractSelectionList.Entry)this);
            }

            public Component m_142172_() {
                String displayName = ((NarrativeEntry)this.item).getName();
                return Component.m_237113_((String)displayName);
            }
        }
    }
}

