/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.KeyframeLocation;
import fr.loudo.narrativecraft.narrative.session.PlayerSession;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.MathHelper;
import fr.loudo.narrativecraft.util.ScreenUtils;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;

public class KeyframeOptionScreen<T extends Keyframe, E extends AbstractKeyframeController<T>>
extends Screen {
    protected final int INITIAL_POS_X = 20;
    protected final int INITIAL_POS_Y = 15;
    protected final int EDIT_BOX_WIDTH = 60;
    protected final int EDIT_BOX_HEIGHT = 15;
    protected final int BUTTON_HEIGHT = 20;
    protected final List<EditBox> coordinatesBoxList = new ArrayList<EditBox>();
    protected final List<Button> littleButtons = new ArrayList<Button>();
    protected final ServerPlayer player;
    protected final PlayerSession playerSession;
    protected final T keyframe;
    protected final E keyframeController;
    protected Runnable reloadScreen;
    protected float upDownValue;
    protected float leftRightValue;
    protected float rotationValue;
    protected float fovValue;
    protected int currentY = 15;
    protected boolean hide;

    public KeyframeOptionScreen(T keyframe, E keyframeController, PlayerSession playerSession, boolean hide) {
        super((Component)Component.m_237113_((String)"Keyframe Option"));
        this.keyframe = keyframe;
        this.player = playerSession.getPlayer();
        this.playerSession = playerSession;
        this.upDownValue = ((Keyframe)keyframe).getKeyframeLocation().getPitch();
        this.leftRightValue = ((Keyframe)keyframe).getKeyframeLocation().getYaw();
        this.rotationValue = ((Keyframe)keyframe).getKeyframeLocation().getRoll();
        this.fovValue = ((Keyframe)keyframe).getKeyframeLocation().getFov();
        this.hide = hide;
        this.keyframeController = keyframeController;
    }

    protected void m_7856_() {
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    protected EditBox addLabeledEditBox(Component text, String defaultValue) {
        StringWidget labelWidget = ScreenUtils.text(text, this.f_96547_, 20, this.currentY);
        EditBox editBox = new EditBox(this.f_96547_, 20 + labelWidget.m_5711_() + 5, this.currentY - labelWidget.m_93694_() / 2, 60, 15, (Component)Component.m_237113_((String)(text.getString() + " Value")));
        editBox.m_94144_(defaultValue);
        editBox.m_94153_(s -> s.matches("^\\d*(\\.\\d*)?$"));
        this.m_142416_((GuiEventListener)labelWidget);
        this.m_142416_((GuiEventListener)editBox);
        this.currentY += 20;
        return editBox;
    }

    protected void initButtons() {
    }

    protected void initPositionLabelBox() {
        String[] labels;
        int currentX = 20;
        int editWidth = 50;
        int i = 0;
        KeyframeLocation position = ((Keyframe)this.keyframe).getKeyframeLocation();
        Double[] coords = new Double[]{position.getX(), position.getY(), position.getZ()};
        for (String label : labels = new String[]{"X:", "Y:", "Z:"}) {
            StringWidget stringWidget = ScreenUtils.text((Component)Component.m_237113_((String)label), this.f_96547_, currentX, this.currentY);
            EditBox box = new EditBox(this.f_96547_, currentX + stringWidget.m_5711_() + 5, this.currentY - stringWidget.m_93694_() / 2, editWidth, 15, (Component)Component.m_237113_((String)(stringWidget + " Value")));
            box.m_94153_(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
            box.m_94144_(String.format(Locale.US, "%.2f", coords[i]));
            this.m_142416_((GuiEventListener)stringWidget);
            this.m_142416_((GuiEventListener)box);
            this.coordinatesBoxList.add(box);
            currentX += stringWidget.m_5711_() + editWidth + 10;
            ++i;
        }
        this.currentY += 20;
    }

    protected void initTextSelectedKeyframe() {
    }

    protected void initLittleButtons() {
        T previousKeyframe;
        int currentX = this.f_96543_ - 20;
        int gap = 5;
        int width = 20;
        if (this.hide) {
            Button eyeClosed = Button.m_253074_((Component)ImageFontConstants.EYE_CLOSED, button -> this.f_96541_.m_91152_(((AbstractKeyframeController)this.keyframeController).keyframeOptionScreen((Keyframe)this.keyframe, false))).m_252987_(currentX - width / 2, 10, width, 20).m_253136_();
            this.littleButtons.add(eyeClosed);
            this.m_142416_((GuiEventListener)eyeClosed);
            return;
        }
        Button closeButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2716"), button -> {
            ((AbstractKeyframeController)this.keyframeController).setCamera(null);
            this.f_96541_.m_91152_(null);
        }).m_252987_(currentX - width / 2, 10, width, 20).m_253136_();
        this.littleButtons.add(closeButton);
        T nextKeyframe = this.keyframeController.getNextKeyframe(this.keyframe);
        if (((Keyframe)nextKeyframe).getId() != ((Keyframe)this.keyframe).getId()) {
            Button rightKeyframeButton = Button.m_253074_((Component)Component.m_237113_((String)"\u25b6"), button -> NarrativeCraftMod.server.execute(() -> ((AbstractKeyframeController)this.keyframeController).setCamera((Keyframe)nextKeyframe))).m_252987_((currentX -= 20 + gap) - width / 2, 10, width, 20).m_253136_();
            this.m_142416_((GuiEventListener)rightKeyframeButton);
        }
        if (((Keyframe)(previousKeyframe = this.keyframeController.getPreviousKeyframe(this.keyframe))).getId() != ((Keyframe)this.keyframe).getId()) {
            Button leftKeyframeButton = Button.m_253074_((Component)Component.m_237113_((String)"\u25c0"), button -> NarrativeCraftMod.server.execute(() -> ((AbstractKeyframeController)this.keyframeController).setCamera((Keyframe)previousKeyframe))).m_252987_((currentX -= 20 + gap) - width / 2, 10, width, 20).m_253136_();
            this.littleButtons.add(leftKeyframeButton);
            this.m_142416_((GuiEventListener)leftKeyframeButton);
        }
        this.m_142416_((GuiEventListener)closeButton);
        Button eyeOpen = Button.m_253074_((Component)ImageFontConstants.EYE_OPEN, button -> this.f_96541_.m_91152_(((AbstractKeyframeController)this.keyframeController).keyframeOptionScreen((Keyframe)this.keyframe, true))).m_252987_((currentX -= 20 + gap) - width / 2, 10, width, 20).m_253136_();
        this.littleButtons.add(eyeOpen);
        this.m_142416_((GuiEventListener)eyeOpen);
    }

    protected void initSliders() {
        int initialY = this.f_96544_ - 50;
        int gap = 5;
        int numSliders = 4;
        int sliderWidth = (this.f_96543_ - gap * (numSliders + 1)) / numSliders;
        int currentX = gap;
        final Function<Float, String> formatFloat = val -> String.format(Locale.US, "%.2f", val);
        float defaultXRot = ((Keyframe)this.keyframe).getKeyframeLocation().getPitch();
        float defaultValXRot = defaultXRot + 90.0f;
        AbstractSliderButton upDownSlider = new AbstractSliderButton(currentX, initialY, sliderWidth, 20, (Component)Translation.message("screen.keyframe_option.up_down", formatFloat.apply(Float.valueOf(defaultValXRot))), defaultValXRot / 180.0f){

            protected void m_5695_() {
                this.m_93666_((Component)Translation.message("screen.keyframe_option.up_down", formatFloat.apply(Float.valueOf(this.getValue() + 90.0f))));
            }

            protected void m_5697_() {
                KeyframeOptionScreen.this.upDownValue = this.getValue();
                KeyframeOptionScreen.this.updateValues();
            }

            public float getValue() {
                return (float)(this.f_93577_ * 180.0 - 90.0);
            }
        };
        EditBox upDownBox = new EditBox(this.f_96547_, currentX, initialY + 20 + 5, 60, 15, (Component)Component.m_237113_((String)"Up Down Value"));
        upDownBox.m_94144_(formatFloat.apply(Float.valueOf(defaultValXRot)));
        upDownBox.m_94153_(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        Button upDownButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2714"), btn -> {
            try {
                this.upDownValue = Float.parseFloat(upDownBox.m_94155_()) - 90.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).m_252987_(currentX + 60 + 5, upDownBox.m_252907_(), 20, 15).m_253136_();
        this.m_142416_((GuiEventListener)upDownSlider);
        this.m_142416_((GuiEventListener)upDownBox);
        this.m_142416_((GuiEventListener)upDownButton);
        float defaultYRot = MathHelper.wrapDegrees360(((Keyframe)this.keyframe).getKeyframeLocation().getYaw());
        AbstractSliderButton leftRightSlider = new AbstractSliderButton(currentX += sliderWidth + gap, initialY, sliderWidth, 20, (Component)Translation.message("screen.keyframe_option.left_right", formatFloat.apply(Float.valueOf(defaultYRot))), defaultYRot / 360.0f){

            protected void m_5695_() {
                float value = MathHelper.wrapDegrees360(((Keyframe)KeyframeOptionScreen.this.keyframe).getKeyframeLocation().getYaw());
                if (value == 0.0f && this.f_93577_ == 1.0) {
                    value = 360.0f;
                }
                this.m_93666_((Component)Translation.message("screen.keyframe_option.left_right", formatFloat.apply(Float.valueOf(value))));
            }

            protected void m_5697_() {
                KeyframeOptionScreen.this.leftRightValue = this.getValue();
                KeyframeOptionScreen.this.updateValues();
            }

            public float getValue() {
                return Mth.m_14177_((float)((float)(this.f_93577_ * 360.0)));
            }
        };
        EditBox leftRightBox = new EditBox(this.f_96547_, currentX, initialY + 20 + 5, 60, 15, (Component)Component.m_237113_((String)"Left Right Value"));
        leftRightBox.m_94144_(formatFloat.apply(Float.valueOf(defaultYRot)));
        leftRightBox.m_94153_(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        Button leftRightButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2714"), btn -> {
            try {
                this.leftRightValue = Float.parseFloat(leftRightBox.m_94155_());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).m_252987_(currentX + 60 + 5, leftRightBox.m_252907_(), 20, 15).m_253136_();
        this.m_142416_((GuiEventListener)leftRightSlider);
        this.m_142416_((GuiEventListener)leftRightBox);
        this.m_142416_((GuiEventListener)leftRightButton);
        float defaultZRot = Mth.m_14177_((float)((Keyframe)this.keyframe).getKeyframeLocation().getRoll());
        AbstractSliderButton rotationSlider = new AbstractSliderButton(currentX += sliderWidth + gap, initialY, sliderWidth, 20, (Component)Translation.message("screen.keyframe_option.rotation", formatFloat.apply(Float.valueOf(defaultZRot))), (((Keyframe)this.keyframe).getKeyframeLocation().getRoll() + 180.0f) % 360.0f / 360.0f){

            protected void m_5695_() {
                float angle = (float)(this.f_93577_ * 360.0 - 180.0);
                this.m_93666_((Component)Translation.message("screen.keyframe_option.rotation", formatFloat.apply(Float.valueOf(angle))));
            }

            protected void m_5697_() {
                float angle = (float)(this.f_93577_ * 360.0 - 180.0);
                KeyframeOptionScreen.this.rotationValue = (angle + 360.0f) % 360.0f;
                KeyframeOptionScreen.this.updateValues();
            }
        };
        EditBox rotationBox = new EditBox(this.f_96547_, currentX, initialY + 20 + 5, 60, 15, (Component)Component.m_237113_((String)"Rotation Value"));
        rotationBox.m_94144_(formatFloat.apply(Float.valueOf(defaultZRot)));
        rotationBox.m_94153_(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        Button rotationButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2714"), btn -> {
            try {
                float angle = Float.parseFloat(rotationBox.m_94155_());
                this.rotationValue = (angle + 360.0f) % 360.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).m_252987_(currentX + 60 + 5, rotationBox.m_252907_(), 20, 15).m_253136_();
        this.m_142416_((GuiEventListener)rotationSlider);
        this.m_142416_((GuiEventListener)rotationBox);
        this.m_142416_((GuiEventListener)rotationButton);
        float defaultFov = ((Keyframe)this.keyframe).getKeyframeLocation().getFov();
        AbstractSliderButton fovSlider = new AbstractSliderButton(currentX += sliderWidth + gap, initialY, sliderWidth, 20, (Component)Translation.message("screen.keyframe_option.fov", formatFloat.apply(Float.valueOf(defaultFov))), defaultFov / 150.0f){

            protected void m_5695_() {
                this.m_93666_((Component)Translation.message("screen.keyframe_option.fov", formatFloat.apply(Float.valueOf(this.getValue()))));
            }

            protected void m_5697_() {
                KeyframeOptionScreen.this.fovValue = this.getValue();
                KeyframeOptionScreen.this.updateValues();
            }

            public float getValue() {
                return (float)(this.f_93577_ * 150.0);
            }
        };
        EditBox fovBox = new EditBox(this.f_96547_, currentX, initialY + 20 + 5, 60, 15, (Component)Component.m_237113_((String)"FOV Value"));
        fovBox.m_94144_(formatFloat.apply(Float.valueOf(defaultFov)));
        fovBox.m_94153_(s -> s.matches("^-?\\d*(\\.\\d*)?$"));
        Button fovButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2714"), btn -> {
            try {
                this.fovValue = Float.parseFloat(fovBox.m_94155_());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.updateValues();
            this.reloadScreen.run();
        }).m_252987_(currentX + 60 + 5, fovBox.m_252907_(), 20, 15).m_253136_();
        this.m_142416_((GuiEventListener)fovSlider);
        this.m_142416_((GuiEventListener)fovBox);
        this.m_142416_((GuiEventListener)fovButton);
    }

    protected void updateValues() {
    }

    public boolean isHide() {
        return this.hide;
    }
}

