/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.components;

import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class StoryElementList
extends ObjectSelectionList<Entry> {
    public StoryElementList(Minecraft minecraft, Screen screen, List<StoryEntryData> entriesData, boolean editButton) {
        super(minecraft, screen.f_96543_, screen.f_96544_, 32, screen.f_96544_ - 65, 24);
        this.m_93471_(false);
        for (StoryEntryData data : entriesData) {
            this.m_7085_((AbstractSelectionList.Entry)new Entry(data, screen, editButton));
        }
    }

    public static class StoryEntryData {
        public final Button mainButton;
        public List<Button> extraButtons;
        public Runnable onDelete;
        public Runnable onUpdate;

        public StoryEntryData(Button mainButton, List<Button> extraButtons, Runnable onUpdate, Runnable onDelete) {
            this.mainButton = mainButton;
            this.extraButtons = extraButtons;
            this.onUpdate = onUpdate;
            this.onDelete = onDelete;
        }

        public StoryEntryData(Button mainButton, Runnable onUpdate, Runnable onDelete) {
            this.mainButton = mainButton;
            this.onUpdate = onUpdate;
            this.onDelete = onDelete;
        }

        public StoryEntryData(Button mainButton) {
            this.mainButton = mainButton;
        }
    }

    public static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final int gap = 5;
        private final Button mainButton;
        private final List<Button> buttons;
        private final Screen screen;

        public Entry(StoryEntryData data, Screen screen, boolean editButton) {
            this.screen = screen;
            this.mainButton = data.mainButton;
            this.buttons = new ArrayList<Button>();
            this.buttons.add(this.mainButton);
            if (data.onUpdate != null && editButton) {
                this.buttons.add(this.createEditButton(data.onUpdate));
                this.buttons.add(this.createRemoveButton(data.onDelete));
            }
            if (data.extraButtons != null) {
                data.extraButtons.forEach(button -> button.m_93674_(20));
                this.buttons.addAll(data.extraButtons);
            }
        }

        private Button createEditButton(Runnable onUpdate) {
            return Button.m_253074_((Component)ImageFontConstants.EDIT, btn -> onUpdate.run()).m_252780_(20).m_253136_();
        }

        private Button createRemoveButton(Runnable onDelete) {
            return Button.m_253074_((Component)ImageFontConstants.REMOVE, btn -> {
                ConfirmScreen confirm = new ConfirmScreen(b -> {
                    if (b) {
                        onDelete.run();
                    } else {
                        Minecraft.m_91087_().m_91152_(this.screen);
                    }
                }, (Component)Component.m_237113_((String)""), (Component)Translation.message("global.confirm_delete", new Object[0]), CommonComponents.f_130657_, CommonComponents.f_130656_);
                Minecraft.m_91087_().m_91152_((Screen)confirm);
            }).m_252780_(20).m_253136_();
        }

        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partial) {
            int totalWidth = this.buttons.stream().mapToInt(AbstractWidget::m_5711_).sum() + (this.buttons.size() - 1) * 5;
            int x = this.screen.f_96543_ / 2 - totalWidth / 2;
            if (this.buttons.size() > 1) {
                x -= 5;
            }
            for (Button button : this.buttons) {
                button.m_264152_(x, top);
                button.m_88315_(graphics, mouseX, mouseY, partial);
                x += button.m_5711_() + 5;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            for (Button btn : this.buttons) {
                if (!btn.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            for (Button btn : this.buttons) {
                btn.m_6348_(mouseX, mouseY, button);
            }
            return false;
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            for (Button btn : this.buttons) {
                btn.m_7979_(mouseX, mouseY, button, dragX, dragY);
            }
            return false;
        }

        public Component m_142172_() {
            return this.mainButton.m_6035_();
        }
    }
}

