/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cameraAngle;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cameraAngle.CameraAngleController;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Animation;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Cutscene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.Subscene;
import fr.loudo.narrativecraft.narrative.character.CharacterStoryData;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframe;
import fr.loudo.narrativecraft.narrative.playback.PlaybackData;
import fr.loudo.narrativecraft.narrative.recording.actions.Action;
import fr.loudo.narrativecraft.narrative.recording.actions.EntityByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.ItemChangeAction;
import fr.loudo.narrativecraft.narrative.recording.actions.LivingEntityByteAction;
import fr.loudo.narrativecraft.narrative.recording.actions.PoseAction;
import fr.loudo.narrativecraft.screens.components.ButtonListScreen;
import fr.loudo.narrativecraft.util.Translation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CameraAngleAddTemplateCharacter
extends ButtonListScreen {
    private final CameraAngleController cameraAngleController;
    private List<Button> buttons = new ArrayList<Button>();

    public CameraAngleAddTemplateCharacter(Screen lastScreen, CameraAngleController cameraAngleController) {
        super(lastScreen, (Component)Translation.message("controller.camera_angle.template_character", cameraAngleController.getCameraAngle().getName()));
        this.cameraAngleController = cameraAngleController;
    }

    public CameraAngleAddTemplateCharacter(Screen lastScreen, Component title, CameraAngleController cameraAngleController, List<Button> buttons) {
        super(lastScreen, title);
        this.cameraAngleController = cameraAngleController;
        this.buttons = buttons;
    }

    @Override
    protected void addContents() {
        this.objectListScreen.clear();
        Scene scene = this.cameraAngleController.getCameraAngle().getScene();
        if (!this.buttons.isEmpty()) {
            for (Button button2 : this.buttons) {
                this.objectListScreen.addButton((AbstractWidget)button2);
            }
            return;
        }
        ArrayList animationsButton = new ArrayList();
        Button animationButton = Button.m_253074_((Component)Translation.message("global.animations", new Object[0]), button -> {
            for (Animation animation : scene.getAnimations()) {
                Button button1 = Button.m_253074_((Component)Component.m_237113_((String)animation.getName()), button2 -> NarrativeCraftMod.server.execute(() -> this.spawnEntity(animation, animation.getActionsData().get(0).getLocations().size() - 1))).m_253136_();
                animationsButton.add(button1);
            }
            this.f_96541_.m_91152_((Screen)new CameraAngleAddTemplateCharacter(this, (Component)Translation.message("global.animations", new Object[0]), this.cameraAngleController, animationsButton));
        }).m_253136_();
        this.objectListScreen.addButton((AbstractWidget)animationButton);
        ArrayList subscenesButton = new ArrayList();
        Button subsceneButton = Button.m_253074_((Component)Translation.message("global.subscenes", new Object[0]), button -> {
            for (Subscene subscene : scene.getSubscenes()) {
                Button button1 = Button.m_253074_((Component)Component.m_237113_((String)subscene.getName()), button2 -> {
                    for (Animation animation : subscene.getAnimations()) {
                        this.spawnEntity(animation, animation.getActionsData().get(0).getLocations().size() - 1);
                    }
                }).m_253136_();
                subscenesButton.add(button1);
            }
            this.f_96541_.m_91152_((Screen)new CameraAngleAddTemplateCharacter(this, (Component)Translation.message("global.subscenes", new Object[0]), this.cameraAngleController, subscenesButton));
        }).m_253136_();
        this.objectListScreen.addButton((AbstractWidget)subsceneButton);
        ArrayList cutscenesButton = new ArrayList();
        Button cutsceneButton = Button.m_253074_((Component)Translation.message("global.cutscenes", new Object[0]), button -> {
            for (Cutscene cutscene : scene.getCutscenes()) {
                if (cutscene.getKeyframeGroups().isEmpty() || cutscene.getSubscenes().isEmpty() && cutscene.getAnimations().isEmpty()) continue;
                Button button1 = Button.m_253074_((Component)Component.m_237113_((String)cutscene.getName()), button2 -> {
                    CutsceneKeyframe lastKeyframe = (CutsceneKeyframe)cutscene.getKeyframeGroups().get(cutscene.getKeyframeGroups().size() - 1).getKeyframes().get(cutscene.getKeyframeGroups().get(cutscene.getKeyframeGroups().size() - 1).getKeyframes().size() - 1);
                    int lastLocIndex = lastKeyframe.getTick() + 2 + lastKeyframe.getTransitionDelayTick();
                    for (Subscene subscene : cutscene.getSubscenes()) {
                        for (Animation animation : subscene.getAnimations()) {
                            this.spawnEntity(animation, Math.min(lastLocIndex, animation.getActionsData().get(0).getLocations().size() - 1));
                        }
                    }
                    for (Animation animation : cutscene.getAnimations()) {
                        this.spawnEntity(animation, Math.min(lastLocIndex, animation.getActionsData().get(0).getLocations().size() - 1));
                    }
                }).m_253136_();
                cutscenesButton.add(button1);
            }
            this.f_96541_.m_91152_((Screen)new CameraAngleAddTemplateCharacter(this, (Component)Translation.message("global.cutscenes", new Object[0]), this.cameraAngleController, cutscenesButton));
        }).m_253136_();
        this.objectListScreen.addButton((AbstractWidget)cutsceneButton);
    }

    @Override
    protected void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130660_, p_345997_ -> this.m_7379_()).m_252780_(200).m_253136_());
    }

    private void spawnEntity(Animation animation, int index) {
        List<Action> actions = animation.getActionsData().get(0).getActions().stream().filter(action -> index >= action.getTick() && (action instanceof ItemChangeAction || action instanceof LivingEntityByteAction || action instanceof EntityByteAction || action instanceof PoseAction)).toList();
        CharacterStoryData characterStoryData = new CharacterStoryData(animation.getCharacter(), animation.getLastLocation(), true, this.cameraAngleController.getCameraAngle().getScene());
        NarrativeCraftMod.server.execute(() -> {
            characterStoryData.spawn(this.cameraAngleController.getPlayerSession().getPlayer().m_9236_(), Environment.DEVELOPMENT);
            PlaybackData playbackData = new PlaybackData(animation.getActionsData().get(0), null);
            playbackData.setEntity((Entity)characterStoryData.getCharacterRuntime().getEntity());
            for (Action action : actions) {
                action.execute(playbackData);
            }
            characterStoryData.applyItems();
            characterStoryData.applyBytes((LivingEntity)playbackData.getEntity());
            this.cameraAngleController.getCharacterStoryDataList().add(characterStoryData);
            this.cameraAngleController.getPlayerSession().getCharacterRuntimes().add(characterStoryData.getCharacterRuntime());
        });
        this.f_96541_.m_91152_(null);
    }
}

