/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.controller.cutscene;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cutscene.CutsceneController;
import fr.loudo.narrativecraft.controllers.keyframe.AbstractKeyframeController;
import fr.loudo.narrativecraft.narrative.keyframes.Keyframe;
import fr.loudo.narrativecraft.narrative.keyframes.cutscene.CutsceneKeyframeGroup;
import fr.loudo.narrativecraft.screens.controller.cutscene.CutsceneSettingsScreen;
import fr.loudo.narrativecraft.screens.keyframe.KeyframeTriggerScreen;
import fr.loudo.narrativecraft.util.ImageFontConstants;
import fr.loudo.narrativecraft.util.Translation;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class CutsceneControllerScreen
extends Screen {
    private final Component pauseText = Component.m_237113_((String)"\u23f8");
    private final Component playText = Component.m_237113_((String)"\u25b6");
    private final int BUTTON_HEIGHT = 20;
    private int initialY;
    private int totalWidthControllerBtn;
    private Button controllerButton;
    private final CutsceneController cutsceneController;

    public CutsceneControllerScreen(CutsceneController cutsceneController) {
        super((Component)Component.m_237113_((String)"Cutscene Controller Screen"));
        this.cutsceneController = cutsceneController;
    }

    protected void m_7856_() {
        this.initialY = this.f_96544_ - 80;
        this.initControllerButtons();
        this.initKeyframesButton();
        this.initSettingsButton();
    }

    private void initControllerButtons() {
        int pauseBtnWidth = 20;
        int btnWidth = 50;
        int gap = 5;
        this.totalWidthControllerBtn = pauseBtnWidth + btnWidth * 2 + gap * 2;
        int startX = (this.f_96543_ - this.totalWidthControllerBtn) / 2;
        String previousText = "- %.1fs";
        Button previousSkip = Button.m_253074_((Component)Component.m_237113_((String)String.format(previousText, (double)this.cutsceneController.getSkipTickCount() / 20.0)), button -> this.cutsceneController.previousSecondSkip()).m_252987_(startX, this.initialY, btnWidth, 20).m_253136_();
        this.controllerButton = Button.m_253074_((Component)(this.cutsceneController.isPlaying() ? this.pauseText : this.playText), button -> this.playOrPause()).m_252987_(startX + btnWidth + gap, this.initialY, pauseBtnWidth, 20).m_253136_();
        String nextText = "+ %.1fs";
        Button nextSkip = Button.m_253074_((Component)Component.m_237113_((String)String.format(nextText, (double)this.cutsceneController.getSkipTickCount() / 20.0)), button -> this.cutsceneController.nextSecondSkip()).m_252987_(startX + btnWidth + gap + pauseBtnWidth + gap, this.initialY, btnWidth, 20).m_253136_();
        this.m_142416_((GuiEventListener)previousSkip);
        this.m_142416_((GuiEventListener)this.controllerButton);
        this.m_142416_((GuiEventListener)nextSkip);
    }

    private void initKeyframesButton() {
        int btnWidth = 30;
        int gap = 5;
        int totalWidth = btnWidth * 3 + gap * 2 + 15;
        int controllerStartX = (this.f_96543_ - this.totalWidthControllerBtn) / 2;
        int startX = controllerStartX - gap - totalWidth;
        Button createKeyframeGroup = Button.m_253074_((Component)ImageFontConstants.CREATE_KEYFRAME_GROUP, button -> {
            CutsceneKeyframeGroup keyframeGroup = this.cutsceneController.createKeyframeGroup();
            if (keyframeGroup == null) {
                return;
            }
            this.f_96541_.f_91074_.m_5661_((Component)Translation.message("controller.cutscene.keyframe_group_created", keyframeGroup.getId()), false);
        }).m_252987_(startX, this.initialY, btnWidth, 20).m_253136_();
        createKeyframeGroup.m_257544_(Tooltip.m_257550_((Component)Translation.message("tooltip.create_keyframe_group", new Object[0])));
        Button addKeyframe = Button.m_253074_((Component)ImageFontConstants.ADD_KEYFRAME, button -> this.cutsceneController.createKeyframe()).m_252987_(startX + btnWidth + gap, this.initialY, btnWidth, 20).m_253136_();
        addKeyframe.m_257544_(Tooltip.m_257550_((Component)Translation.message("tooltip.create_keyframe", new Object[0])));
        Button addTriggerKeyframe = Button.m_253074_((Component)ImageFontConstants.ADD_KEYFRAME_TRIGGER, button -> {
            KeyframeTriggerScreen screen = new KeyframeTriggerScreen((AbstractKeyframeController<? extends Keyframe>)this.cutsceneController, this.cutsceneController.getCurrentTick());
            this.f_96541_.m_91152_((Screen)screen);
        }).m_252987_(startX + (btnWidth + gap) * 2, this.initialY, btnWidth, 20).m_253136_();
        addTriggerKeyframe.m_257544_(Tooltip.m_257550_((Component)Translation.message("tooltip.create_keyframe_trigger", new Object[0])));
        this.m_142416_((GuiEventListener)createKeyframeGroup);
        this.m_142416_((GuiEventListener)addKeyframe);
        this.m_142416_((GuiEventListener)addTriggerKeyframe);
    }

    private void initSettingsButton() {
        int btnWidth = 30;
        int controllerStartX = (this.f_96543_ - this.totalWidthControllerBtn) / 2;
        int startX = controllerStartX + this.totalWidthControllerBtn + 15;
        Button settingsButton = Button.m_253074_((Component)ImageFontConstants.SETTINGS, button -> this.f_96541_.m_91152_((Screen)new CutsceneSettingsScreen(this.cutsceneController, this, (Component)Translation.message("controller.cutscene.settings.screen_name", new Object[0])))).m_252987_(startX, this.initialY, btnWidth, 20).m_253136_();
        settingsButton.m_257544_(Tooltip.m_257550_((Component)Translation.message("tooltip.cutscene_settings", new Object[0])));
        this.m_142416_((GuiEventListener)settingsButton);
        startX = settingsButton.m_252754_() + settingsButton.m_5711_() + 5;
        Button saveButton = Button.m_253074_((Component)ImageFontConstants.SAVE, button -> {
            NarrativeCraftMod.server.execute(() -> this.cutsceneController.stopSession(true));
            this.m_7379_();
        }).m_252987_(startX, this.initialY, btnWidth, 20).m_253136_();
        saveButton.m_257544_(Tooltip.m_257550_((Component)Translation.message("tooltip.save", new Object[0])));
        this.m_142416_((GuiEventListener)saveButton);
        startX = saveButton.m_252754_() + saveButton.m_5711_() + 5;
        Button closeButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2716"), button -> {
            ConfirmScreen confirm = new ConfirmScreen(b -> {
                if (b) {
                    NarrativeCraftMod.server.execute(() -> this.cutsceneController.stopSession(false));
                    this.m_7379_();
                } else {
                    this.f_96541_.m_91152_((Screen)this);
                }
            }, (Component)Component.m_237113_((String)""), (Component)Translation.message("controller.confirm_leaving", new Object[0]), CommonComponents.f_130657_, CommonComponents.f_130656_);
            this.f_96541_.m_91152_((Screen)confirm);
        }).m_252987_(startX, this.initialY, btnWidth, 20).m_253136_();
        closeButton.m_257544_(Tooltip.m_257550_((Component)Translation.message("tooltip.leave_without_saving", new Object[0])));
        this.m_142416_((GuiEventListener)closeButton);
    }

    private void playOrPause() {
        if (this.cutsceneController.isPlaying()) {
            this.cutsceneController.pause();
            this.controllerButton.m_93666_(this.playText);
        } else {
            if (this.cutsceneController.atMaxTick()) {
                return;
            }
            this.cutsceneController.resume();
            this.controllerButton.m_93666_(this.pauseText);
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    public boolean m_7043_() {
        return false;
    }

    public Button getControllerButton() {
        return this.controllerButton;
    }

    public Component getPauseText() {
        return this.pauseText;
    }

    public Component getPlayText() {
        return this.playText;
    }
}

