/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.narrativecraft.screens.storyManager.cameraAngle;

import fr.loudo.narrativecraft.NarrativeCraftMod;
import fr.loudo.narrativecraft.controllers.cameraAngle.CameraAngleController;
import fr.loudo.narrativecraft.files.NarrativeCraftFile;
import fr.loudo.narrativecraft.narrative.Environment;
import fr.loudo.narrativecraft.narrative.chapter.scene.Scene;
import fr.loudo.narrativecraft.narrative.chapter.scene.data.CameraAngle;
import fr.loudo.narrativecraft.screens.components.EditInfoScreen;
import fr.loudo.narrativecraft.screens.components.StoryElementList;
import fr.loudo.narrativecraft.screens.storyManager.StoryElementScreen;
import fr.loudo.narrativecraft.screens.storyManager.cameraAngle.EditScreenCameraAngleAdapter;
import fr.loudo.narrativecraft.screens.storyManager.scene.ScenesMenuScreen;
import fr.loudo.narrativecraft.util.Translation;
import fr.loudo.narrativecraft.util.Util;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class CameraAngleScreen
extends StoryElementScreen {
    private final Scene scene;

    public CameraAngleScreen(Scene scene) {
        super((Component)Translation.message("screen.story_manager.camera_angle_list", scene.getName()));
        this.scene = scene;
    }

    @Override
    protected void addTitle() {
        super.addTitle();
        this.initAddButton(button -> {
            EditInfoScreen<CameraAngle> screen = new EditInfoScreen<CameraAngle>((Screen)this, null, new EditScreenCameraAngleAdapter(this.scene));
            this.f_96541_.m_91152_(screen);
        });
        this.initFolderButton();
    }

    @Override
    protected void addFooter() {
        this.layout.m_269281_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130660_, p_345997_ -> this.m_7379_()).m_252780_(200).m_253136_());
    }

    public void m_7379_() {
        this.f_96541_.m_91152_((Screen)new ScenesMenuScreen(this.scene));
    }

    @Override
    protected void addContents() {
        List<StoryElementList.StoryEntryData> entries = this.scene.getCameraAngles().stream().map(cameraAngle -> {
            Button button = Button.m_253074_((Component)Component.m_237113_((String)cameraAngle.getName()), button1 -> {
                NarrativeCraftMod.server.execute(() -> new CameraAngleController(Environment.DEVELOPMENT, (Player)this.f_96541_.f_91074_, (CameraAngle)cameraAngle).startSession());
                this.f_96541_.m_91152_(null);
            }).m_253136_();
            return new StoryElementList.StoryEntryData(button, () -> this.f_96541_.m_91152_(new EditInfoScreen<CameraAngle>((Screen)this, (CameraAngle)cameraAngle, new EditScreenCameraAngleAdapter(this.scene))), () -> {
                this.f_96541_.m_91152_((Screen)new CameraAngleScreen(this.scene));
                try {
                    this.scene.removeCameraAngleGroup((CameraAngle)cameraAngle);
                    NarrativeCraftFile.updateCameraAngles(this.scene);
                    this.f_96541_.m_91152_((Screen)new CameraAngleScreen(this.scene));
                }
                catch (Exception e) {
                    this.scene.addCameraAngleGroup((CameraAngle)cameraAngle);
                    Util.sendCrashMessage((Player)this.f_96541_.f_91074_, e);
                }
            });
        }).toList();
        this.storyElementList = new StoryElementList(this.f_96541_, (Screen)this, entries, true);
    }

    @Override
    protected void openFolder() {
        net.minecraft.Util.m_137581_().m_137644_(NarrativeCraftFile.getSceneFolder(this.scene));
    }
}

